#include "../binary_c.h"

#ifdef NUCSYN


Abundance nucsyn_elemental_abundance_by_number(const char * RESTRICT const element, 
                                               const Abundance * RESTRICT const X,
                                               struct stardata_t * const stardata,
                                               struct store_t * const store,
                                               const double density)
{
    /*
     * Given an element string, calculate the elemental abundance
     * by mass fraction, given a list of surface mass fractions.
     *
     * Return -1.0 (unphysical) on a set up call.
     */

    Abundance Nelem; // calculated number density (returned)

   if(unlikely(element==NULL && X==NULL))
    {
        /* set up call */
        if(store->icache==NULL)
        {
            nucsyn_make_icache(store);
        }
        else
        {
            nucsyn_free_icache(store->icache);
        }
        Nelem = -1.0; /* unphysical */
    }
    else
    {
        /*
         * ID isotopes of this element
         */

        /* calculate the atomic number of the element */
        Atomic_number Z = nucsyn_element_to_atomic_number(store,element);
        const Nuclear_mass * const imnuc = stardata->store->imnuc;
        Isotope ** const icache = store->icache;
        Nelem = 0.0;
        
        /* add abundances from isotope numbers stored in icache */
        Element c;
        for(c=0;c<MAX_ISOTOPES_PER_ELEMENT;c++)
        {
            if(icache[Z][c]!=0)
            {
                const Isotope i = icache[Z][c]; 
                Nelem += imnuc[i] * density * X[i];
            }
        }
    }

    return Nelem;
}




#endif // NUCSYN
 
