#include "../binary_c.h"

#ifdef NUCSYN

Abundance nucsyn_elemental_abundance(const char * RESTRICT const element, 
                                     const Abundance * RESTRICT const X,
                                     struct stardata_t * const stardata,
                                     struct store_t * const store)
{
    /*
     * Given an element string, calculate the elemental abundance
     * by mass fraction, given a list of surface mass fractions.
     *
     * Return -1.0 (unphysical) on a set up call.
     */

    Abundance Xelem; // calculated mass fraction (returned)

    if(unlikely(element==NULL && X==NULL))
    {
        /* 
         * Set up call 
         */
        if(store->icache==NULL)
        {
            nucsyn_make_icache(store);
        }
        else
        {
            nucsyn_free_icache(store->icache);
        }
        Xelem = -1.0; /* unphysical */
    }
    else
    {
        /*
         * ID isotopes of this element
         */

        /* calculate the atomic number of the element */
        Atomic_number Z = nucsyn_element_to_atomic_number(store,element);
        Isotope ** const icache = store->icache;
        Xelem = 0.0;
        
        /* add abundances from isotope numbers stored in icache */
        Element c;
        for(c=0;c<MAX_ISOTOPES_PER_ELEMENT;c++)
        {
            if(icache[Z][c]!=0) Xelem += X[icache[Z][c]];
        }
    }
    
    return Xelem;
}




#endif // NUCSYN
 
