#include "nucsyn.h"
#ifdef NUCSYN
void nucsyn_dilute_shell(const double m1, 
                         Abundance * RESTRICT const X1,
                         const double m2, 
                         const Abundance * const RESTRICT X2)
{

    /* 
     * Mix shell 2 into shell 1 without changing shell 2 
     * (shell 1 is changed).
     */
    const double f1 = m1 / (m1 + m2);
    const double f2 = 1.0 - f1;

    {
#ifdef USE_POINTER_LOOPS
    Abundance * RESTRICT p = X1;
    const Abundance * RESTRICT q = X2;
    const Abundance * RESTRICT max = &X1[ISOTOPE_ARRAY_SIZE];
    for(p=X1; p < max; ++p, ++q)
    {
        prefetch(p+1);
        prefetch(q+1);
        *p = f1 * *p + f2 * *q;
    }
#else
    Isotope i;
    Isotope_loop(i)
    {
        prefetch(X1+Isotope_loop_sign);
        prefetch(X2+Isotope_loop_sign);
        X1[i] = f1 * X1[i] + f2 * X2[i];
    }
#endif // USE_POINTER_LOOPS
    }
}
#endif // NUCSYN
