#include "../binary_c.h"

/*
 * Function to log CEMP or XEMP stars:
 *
 * If the star is NOT a CEMP or a NEMP, it is XEMP
 * 
 * A star can be a CEMP *AND* a NEMP at the same time!
 */

#ifdef NUCSYN_CEMP_LOGGING
#define CO_RATIO(k) (Xenv[XC12]/Xenv[XO16]*16.0/12.0)
#define SQUARE_BRACKET(A,B) nucsyn_square_bracket(Xenv,         \
					          Xsolar,       \
                                                  (A),(B))




#ifdef NUCSYN_CEMP_CRITERIA_O1
#define CEMP_CRITERIA ((cfe_bracket > stardata->preferences->CEMP_cfe_minimum) )
#define NEMP_CRITERIA ((nfe_bracket > 1.0)&&(cn_bracket<-0.5)&&(cfe_bracket>0.0))
#else
#define CEMP_CRITERIA (cfe_bracket > stardata->preferences->CEMP_cfe_minimum)
#define NEMP_CRITERIA ((nfe_bracket > 0.5)&&(cn_bracket<-0.5))
#endif

static void nucsyn_cemp_dump(struct stardata_t * stardata,
			     struct star_t * star,
			     double dt,
			     Abundance * Xenv);

void nucsyn_cemp_log(struct stardata_t * RESTRICT const stardata)
{
    Abundance *Xsolar=stardata->common.Xsolar;
    double dt;
    struct star_t * star MAYBE_UNUSED;
    Star_number k;
    char s[100];
  
    if(stardata->model.time<TINY) 
    {
        stardata->model.cemp_log_prevt=0.0; // first timestep
    }
    dt = stardata->model.time - Max(stardata->model.cemp_log_prevt,
                                    stardata->preferences->CEMP_minimum_age)
        ; // calculate time since previous output

    stardata->model.cemp_log_prevt = stardata->model.time;

    /* timestep in Myr */
    dt = stardata->model.dtm;
    
    /*
     * Look for CEMP stars
     */
    if(stardata->model.time>stardata->preferences->CEMP_minimum_age)
    {
        Starloop(k)
	{
            SETstar(k);
            Abundance * Xenv=nucsyn_observed_surface_abundances(star);

            /* calculate logg */
            double log10g=logg(star);

            //#define USEFUL_LOGGING_HERE
#ifdef USEFUL_LOGGING_HERE
            /*
             * Useful to check if non-thermohaline mixing is
             * working
             */
            if((k==1)&&(stardata->star[1].stellar_type<10))
	    {
                Printf("STAR2 t=%g st=%d log10g=%g [C/Fe]=%g [N/Fe]=%g C12=%g C13=%g\n",
                       stardata->model.time,
                       stardata->star[1].stellar_type,
                       log10g,
                       nucsyn_square_multibracket(Xenv,Xsolar,
                                                  (Isotope[]){XC12,XC13},2,
                                                  (Isotope[]){XFe52,XFe54,XFe56,XFe57,XFe58},5),
                       nucsyn_square_multibracket(Xenv,Xsolar,
                                                  (Isotope[]){XN14,XN15},2,
                                                  (Isotope[]){XFe52,XFe54,XFe56,XFe57,XFe58},5),
                       star->Xenv[XC12],
                       star->Xenv[XC13]
                    );
	    }
#endif
            /*
             * Check for infamous C12<0 error :(
             */
            if(star->Xenv[XC12]<0.0)
            {
                Exit_binary_c(BINARY_C_OUT_OF_RANGE,
                              "XC12 = %g < 0 error in nucsyn_cemp_log\n",
                              star->Xenv[XC12]
                    );
	      
            }

	  
            /* calculate N/Fe including minor isotopes */
            Abundance nfe_bracket=nucsyn_square_multibracket(Xenv,Xsolar,
                                                             (Isotope[]){XN14,XN15},2,
                                                             (Isotope[]){XFe52,XFe54,XFe56,XFe57,XFe58},5);
	  
	  /* calculate [C/N] including minor isotopes */
	  Abundance cn_bracket=nucsyn_square_multibracket(Xenv,Xsolar,
							  (Isotope[]){XC12,XC13},2,
							  (Isotope[]){XN14,XN15},2);

	  /* calculate C/Fe including minor isotopes */
	  Abundance cfe_bracket=nucsyn_square_multibracket(Xenv,Xsolar,
							   (Isotope[]){XC12,XC13},2,
							   (Isotope[]){XFe52,XFe54,XFe56,XFe57,XFe58},5);
	   
//#define MORE_LOGGING
#ifdef MORE_LOGGING
	  if(star->stellar_type==HG || star->stellar_type==GIANT_BRANCH)
	  {
	      int c=Other_star(k);
	      Printf("EMPcheck %d st=%d time=%g [C/Fe]=%g [N/Fe]=%g [C/N]=%g C/N=%g : companion %d st=%d [C/Fe]=%g [N/Fe]=%g [C/N]=%g C/N=%g\n",
		     k,
                     star->stellar_type,
                     stardata->model.time,
                     cfe_bracket,
		     nfe_bracket,
		     cn_bracket,
		     Xenv[XC12]/Xenv[XN14],

		     c,stardata->star[c].stellar_type,
		     nucsyn_square_multibracket(stardata->star[c].Xenv,Xsolar,
						(Isotope[]){XC12,XC13},2,
						(Isotope[]){XFe52,XFe54,XFe56,XFe57,XFe58},5),
		     nucsyn_square_multibracket(stardata->star[c].Xenv,Xsolar,
						(Isotope[]){XN14,XN15},2,
						(Isotope[]){XFe52,XFe54,XFe56,XFe57,XFe58},5),
		     nucsyn_square_multibracket(stardata->star[c].Xenv,Xsolar,
						(Isotope[]){XC12,XC13},2,
						(Isotope[]){XN14,XN15},2),
		     stardata->star[c].Xenv[XC12]/stardata->star[c].Xenv[XN14]
		     
		     
		  );
	  }
#endif
		     
	  /*
	   * log_10 (g) < 4.0 - same as the observations
	   * and pre-WD
	   */
	  if(star->stellar_type < HeWD &&
             star->mass > 0.1 &&
	     log10g < stardata->preferences->CEMP_logg_maximum)
          {
              // EMP giant

	    
	      Boolean special=FALSE; // set TRUE if star is CEMP or NEMP
	      
	      /* 
	       * Check if we're a CEMP:
	       * use C/O>1.0 or [C/Fe]> stardata->preferences->CEMP_cfe_minimum 
	       * (usually 1.0)
	       */
	      

	      if(CEMP_CRITERIA)
              {
		  // CEMP giant
		  Printf("C");
		  special = TRUE;
		  // log first time
		  if(star->cemp==FALSE)
                  {
		      star->cemp=TRUE;

		      /* only log if CEMP and not CNEMP (taken care of later) */
		      if(!NEMP_CRITERIA)
                      {
			  snprintf(s,100,"CEMP%d",(int)k);
			  output_to_logfile(stardata->model.log_fp,
					    stardata->model.time,
					    stardata->star[0].mass,
					    stardata->star[1].mass,
					    stardata->star[0].stellar_type,
					    stardata->star[1].stellar_type,
					    stardata->common.orbit.separation,
					    stardata->common.orbit.eccentricity,
					    stardata->star[0].radius/stardata->star[0].roche_radius,
					    stardata->star[1].radius/stardata->star[1].roche_radius,
					    s,stardata);
                      }
                  }
              }
              else if(star->cemp==TRUE)
              {
                  /* was a CEMP, no longer a CEMP, but still EMP giant */
                  snprintf(s,100,"endCEMP%d",(int)k);
                  output_to_logfile(stardata->model.log_fp,
                                    stardata->model.time,
                                    stardata->star[0].mass,
                                    stardata->star[1].mass,
                                    stardata->star[0].stellar_type,
                                    stardata->star[1].stellar_type,
                                    stardata->common.orbit.separation,
                                    stardata->common.orbit.eccentricity,
                                    stardata->star[0].radius/stardata->star[0].roche_radius,
                                    stardata->star[1].radius/stardata->star[1].roche_radius,
                                    s,stardata);
                  star->cemp=FALSE;
              }
	       
	      
	      /* 
	       * Check if we're a NEMP:
	       * [N/Fe]>+0.5, [C/N]<-0.5 (normal criteria)
	       */
              if(NEMP_CRITERIA)
              {
		  // NEMP giant
		  Printf("N");
		  special=TRUE;
		  // log first time
		  if(star->nemp==FALSE)
                  {
		      star->nemp=TRUE;
		      if(star->cemp==TRUE)
                      {
			  snprintf(s,100,"CNEMP%d",(int)k);
                      }
		      else
                      {
			  snprintf(s,100,"NEMP%d",(int)k);
                      }
		      output_to_logfile(stardata->model.log_fp,
					stardata->model.time,
					stardata->star[0].mass,
					stardata->star[1].mass,
					stardata->star[0].stellar_type,
					stardata->star[1].stellar_type,
					stardata->common.orbit.separation,
					stardata->common.orbit.eccentricity,
					stardata->star[0].radius/stardata->star[0].roche_radius,
					stardata->star[1].radius/stardata->star[1].roche_radius,
					s,stardata);
                  }		  
              }
	      else if(star->nemp==TRUE)
              {
		  /* was a NEMP, no longer a NEMP, but still EMP giant  */
		  snprintf(s,100,"endNEMP%d",(int)k);
		  output_to_logfile(stardata->model.log_fp,
				    stardata->model.time,
				    stardata->star[0].mass,
				    stardata->star[1].mass,
				    stardata->star[0].stellar_type,
				    stardata->star[1].stellar_type,
				    stardata->common.orbit.separation,
				    stardata->common.orbit.eccentricity,
				    stardata->star[0].radius/stardata->star[0].roche_radius,
				    stardata->star[1].radius/stardata->star[1].roche_radius,
				    s,stardata);
		  star->nemp=FALSE;
              }


	      if(special==FALSE)
              {
		  // non-C EMP giant
		  Printf("X");
		  star->cemp=FALSE;
		  star->nemp=FALSE;
		  if(star->xemp==FALSE)
                  {
		      star->xemp=TRUE;
		      snprintf(s,100,"XEMP%d %g",(int)k,log10g);
		      output_to_logfile(stardata->model.log_fp,
					stardata->model.time,
					stardata->star[0].mass,
					stardata->star[1].mass,
					stardata->star[0].stellar_type,
					stardata->star[1].stellar_type,
					stardata->common.orbit.separation,
					stardata->common.orbit.eccentricity,
					stardata->star[0].radius/stardata->star[0].roche_radius,
					stardata->star[1].radius/stardata->star[1].roche_radius,
					s,stardata);
                  }
              }

	      /* need some info */
	      nucsyn_cemp_dump(stardata,star,dt,Xenv);
          }
	  else
          {
	      /* end of CEMP/NEMP phase because we're no longer a giant */
	      if((star->cemp==TRUE)&&(star->nemp==TRUE))
              {
		  /* was a CNEMP, no longer a CNEMP */
		  snprintf(s,100,"endCNEMP%d",(int)k);
                  output_to_logfile(stardata->model.log_fp,
                                    stardata->model.time,
                                    stardata->star[0].mass,
                                    stardata->star[1].mass,
                                    stardata->star[0].stellar_type,
                                    stardata->star[1].stellar_type,
                                    stardata->common.orbit.separation,
                                    stardata->common.orbit.eccentricity,
                                    stardata->star[0].radius/stardata->star[0].roche_radius,
                                    stardata->star[1].radius/stardata->star[1].roche_radius,
                                    s,stardata);
                  star->cemp=FALSE;
                  star->nemp=FALSE;
              }
	      else
              {
		  if(star->cemp==TRUE)
                  {
		      /* was a CEMP, no longer a CEMP */
		      snprintf(s,100,"endCEMP%d",(int)k);
		      output_to_logfile(stardata->model.log_fp,
					stardata->model.time,
					stardata->star[0].mass,
					stardata->star[1].mass,
					stardata->star[0].stellar_type,
					stardata->star[1].stellar_type,
					stardata->common.orbit.separation,
					stardata->common.orbit.eccentricity,
					stardata->star[0].radius/stardata->star[0].roche_radius,
					stardata->star[1].radius/stardata->star[1].roche_radius,
					s,stardata);
		      star->cemp=FALSE;
                  }
		  else if(star->nemp==TRUE)
                  {
		      /* was a NEMP, no longer a NEMP */
		      snprintf(s,100,"endNEMP%d",(int)k);
		      output_to_logfile(stardata->model.log_fp,
					stardata->model.time,
					stardata->star[0].mass,
					stardata->star[1].mass,
					stardata->star[0].stellar_type,
					stardata->star[1].stellar_type,
					stardata->common.orbit.separation,
					stardata->common.orbit.eccentricity,
					stardata->star[0].radius/stardata->star[0].roche_radius,
					stardata->star[1].radius/stardata->star[1].roche_radius,
					s,stardata);
		      star->nemp=FALSE;
                  }
              }
	      if(star->xemp==TRUE)
              {
		  /* was a XEMP, no longer a XEMP */
		  snprintf(s,100,"endXEMP%d",(int)k);
		  output_to_logfile(stardata->model.log_fp,
				    stardata->model.time,
				    stardata->star[0].mass,
				    stardata->star[1].mass,
				    stardata->star[0].stellar_type,
				    stardata->star[1].stellar_type,
				    stardata->common.orbit.separation,
				    stardata->common.orbit.eccentricity,
				    stardata->star[0].radius/stardata->star[0].roche_radius,
				    stardata->star[1].radius/stardata->star[1].roche_radius,
				    s,stardata);
		  star->xemp=FALSE;
              }
          }
	}
    }

    //else 
    if(stardata->model.time<TINY)
    {
        /* first timestep, reset the cemp/nemp booleans */
        stardata->star[0].cemp=FALSE;
        stardata->star[0].nemp=FALSE;
        stardata->star[0].xemp=FALSE;
        stardata->star[1].cemp=FALSE;
        stardata->star[1].nemp=FALSE;
        stardata->star[1].xemp=FALSE;
    }
}


static void nucsyn_cemp_dump(struct stardata_t * stardata,
			     struct star_t * star,
			     double dt,
			     Abundance * Xenv)
{
    Star_number k = star->starnum;
    Abundance *Xsolar=stardata->common.Xsolar;
  
    Printf("EMP %10.10f %g %g %d %g %g %g %g %g %g %g %g ",
           stardata->model.time,  // 1
           dt, 
           stardata->model.probability,
           star->stellar_type, // 4
           star->mass, // 5
           star->luminosity, // 6
           star->radius, // 7
           Teff(k), //8
		
           log10(TINY+GRAVITATIONAL_CONSTANT*M_SUN*star->mass/Pow2(star->radius*R_SUN)) /*log g*/,
           stardata->common.orbit.separation, // 10 Rsun
           stardata->common.orbit.period, // 11 years
           stardata->common.orbit.eccentricity // 12
        );

    Printf("%g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g %g\n",
           CO_RATIO(k), // 13
           SQUARE_BRACKET(XFe56,XH1),
           SQUARE_BRACKET(XC12,XFe56), // 15 
           SQUARE_BRACKET(XC13,XFe56),
           SQUARE_BRACKET(XN14,XFe56),
           SQUARE_BRACKET(XO16,XFe56),
           SQUARE_BRACKET(XNe20,XFe56),
           SQUARE_BRACKET(XNe22,XFe56), // 20
           SQUARE_BRACKET(XNa23,XFe56),
           SQUARE_BRACKET(XMg24,XFe56),
           SQUARE_BRACKET(XSi28,XFe56),
           SQUARE_BRACKET(XK39,XFe56),
           SQUARE_BRACKET(XCa40,XFe56), // 25
           SQUARE_BRACKET(XV51,XFe56),
           SQUARE_BRACKET(XCr52,XFe56),
           SQUARE_BRACKET(XCo59,XFe56),
           nucsyn_elemental_square_bracket("Ba","Fe",Xenv,Xsolar,stardata),
           nucsyn_elemental_square_bracket("Y","Fe",Xenv,Xsolar,stardata),//30
           nucsyn_elemental_square_bracket("Zr","Fe",Xenv,Xsolar,stardata),
           nucsyn_elemental_square_bracket("Pb","Fe",Xenv,Xsolar,stardata),
           nucsyn_elemental_square_bracket("Kr","Fe",Xenv,Xsolar,stardata),
           nucsyn_elemental_square_bracket("Eu","Fe",Xenv,Xsolar,stardata),//34
           (13.0/12.0)*Xenv[XC12]/Max(TINY,Xenv[XC13]), //35,
           nucsyn_elemental_square_bracket("Ba","Y",Xenv,Xsolar,stardata),
           nucsyn_elemental_square_bracket("Pb","Ba",Xenv,Xsolar,stardata),
           nucsyn_elemental_square_bracket("Pb","Y",Xenv,Xsolar,stardata),
           nucsyn_elemental_square_bracket("Sr","Fe",Xenv,Xsolar,stardata), //39
           SQUARE_BRACKET(XAl27,XFe56), // 40
           SQUARE_BRACKET(XF19,XFe56), //41
           nucsyn_elemental_square_bracket("La","Fe",Xenv,Xsolar,stardata) //42

        );

}
			

#endif

