#include "../binary_c.h"
#ifdef NUCSYN

/*
 * Todo: 
 *
 * Remove planetary nebula call: it shouldn't be in here.
 */

void Hot_function nucsyn_calc_yields(struct stardata_t * RESTRICT const stardata,
                                     struct star_t * const star,
                                     const double dmlose, /* mass lost as wind/otherwise */
                                     const Abundance * const Xlose, /* abundance of this "wind" */
                                     const double dmacc, /* mass gained by accretion */
                                     const Abundance * const Xacc, /* abundance of this accretion */
                                     const Star_number starnum,
                                     const int final,
                                     const Yield_source source
    )
{
    Dprint("Calc yields! star=%d int %s source=%d=%s final=%d, M=%g Menv=%g, dmlose=%g, Xlose=%p (tot %g, C12 %g), dmacc=%g, Xacc=%p (tot %g, C12 %g)\n",
           starnum,
           Yesno(stardata->model.intermediate_step),
           source,
           Nucsyn_source_string(source),
           final,
           star->mass,
           star->mass - star->core_mass,
           dmlose,
           Xlose,
           (Xlose ? XXsum(stardata,Xlose) : -1.0),
           (Xlose ? Xlose[XC12] : -1.0),
           dmacc,
           Xacc,
           (Xacc ? XXsum(stardata,Xacc) : -1.0),
           (Xacc ? Xacc[XC12] : -1.0)
        );

#ifdef NUCSYN_YIELDS    
    /*
         * The mass lost by a star is dmlose, with the mass gained dmacc (both are positive). 
         * The mass of each element gained or lost can then be calculated from the
         * abundances in Xlose and Xacc
         *
         * These values CAN BE Negative_nonzero in the case of accretion being higher than
         * loss to the ISM, however you WOULD EXPECT that in the single star case
         * this is impossible, and in most binary stars by the end of their lives
         * (1) both stars will have all positive values of yields (2) overall the
         * yield is positive
         *
         * Final is an int. If it is 2 in which case we
         * still yield even for a massless remnant (useful for common envelope
         * evolution where the two stars merge then explode).
         *
         * source tells you where the mass came from: GB/AGB/WR/SN etc. 
         * the numbers are defined in nucsyn_macros.h
         */
    
    
        /* If dm is too small, do nothing! */
        if(final==YIELD_NOT_FINAL &&
           Is_zero(dmlose) &&
           Is_zero(dmacc))
        {
            Dprint("NO Add_yield dmlose=%g dmac=%g\n",dmlose,dmacc);
        }
        else if (stardata->model.time <
                 (stardata->preferences->yields_logtimes == TRUE ? 
                  stardata->preferences->yields_startlogtime : 0.0))
        {
            Dprint("too early for yield\n");
        }
        else
        {
            Isotope i;
            Abundance * const Xyield = star->Xyield; 
#ifdef NUCSYN_LOG_MPYIELDS
            const double dm = dmacc - dmlose;
            double * mpyield;
            const Abundance * const XZAMS = stardata->common.XZAMS;
#endif//NUCSYN_LOG_MPYIELDS
#ifdef NUCSYN_GCE_OUTFLOW_CHECKS
            double t;
#endif//GCE_OUTFLOW_CHECKS

            /************/

#ifdef NANCHECKS
            nancheck("nucsyn_calc_yields start Xyield",star->Xyield,ISOTOPE_ARRAY_SIZE);
            nancheck("nucsyn_calc_yields start Xenv",star->Xenv,ISOTOPE_ARRAY_SIZE);
            nancheck("nucsyn_calc_yields start Xlose",Xlose,ISOTOPE_ARRAY_SIZE);
#endif//NANCHECKS

#ifdef NUCSYN_GCE_OUTFLOW_CHECKS
            Dprint("Outflow checks...\n");

            if(star->vwind > stardata->preferences->escape_velocity && Xlose!=NULL)
            {
// modulate by escape fraction
                t = 1.0 - stardata->preferences->escape_fraction;
                Isotope_loop(i)
                {
                    Xlose[i] *= t;
                }
            }
#endif//GCE_OUTFLOW_CHECKS
        
            Dprint("nucsyn_calc_yields (star %d,type %d,M=%30.20e,source=%d,intermediate=%d) dmlose=%g, dmacc=%g, Xenv XH1=%g mass to ISM (or other star) %g [wind dM/dt=%g expect %g lost]\n",
                   star->starnum,
                   star->stellar_type,
                   star->mass,
                   source,
                   stardata->model.intermediate_step,
                   dmlose,
                   dmacc,
                   star->Xenv[XH1],
                   Max(dmlose-dmacc,0.0),
                   star->derivative[DERIVATIVE_STELLAR_MASS_WIND_LOSS],
                   star->derivative[DERIVATIVE_STELLAR_MASS_WIND_LOSS] * stardata->model.dt

                );
    
            /* We always want to calculate the yields... */
#ifdef NUCSYN_LOG_INDIVIDUAL_DX_YIELDS
            Printf("DXYIELD%d__ ",starnum);
            Dprint("(dmlose=%g dmacc=%g) ",starnum,dmlose,dmacc);
#endif//NUCSYN_LOG_INDIVIDUAL_DX_YIELDS
    
#ifdef NUCSYN_PLANETARY_NEBULAE
/*
 * Wind loss causes a PN in TPAGB stars, but goes via
 * comenv (logged elsewhere)
 */
            if(star->stellar_type==TPAGB && dmlose > 0.0)
            {
// check for PNe
                nucsyn_planetary_nebulae(stardata,
                                         PNE_AGB,
                                         star->starnum,
                                         dmlose,
                                         star->Xenv,
                                         0.0);
            }
#endif
    
            if(Is_zero(dmacc))
            {
                /*
                 * Material is only lost, Xacc can be NULL
                 */
                if(Is_not_zero(dmlose) && Xlose != NULL)
                {
                    // this is the most likely case, hence it is first
                    Dprint("dmlose > TINY\n");

                    const double dmlp = dmlose * stardata->model.probability;
                    
#ifdef NUCSYN_ID_SOURCES
                    // dmlose > 0 and dmacc < 0
                    Abundance * const Xsource = star->Xsource[source];
#endif
#ifdef NUCSYN_LOG_MPYIELDS
                    const double dmp = dm*stardata->model.probability;
#endif

                    Isotope_loop(i)
                    {
                        //prefetch(Xlose+i+Isotope_loop_sign);
#if defined NUCSYN_ID_SOURCES || defined NUCSYN_LOG_MPYIELDS
                        const double dy = dmlp * Xlose[i];
#else
#define dy ( dmlp * Xlose[i] )
#endif
                    
                        Xyield[i] += dy;

#ifdef NUCSYN_ID_SOURCES
                        Xsource[i] += dy;
#endif //NUCSYN_ID_SOURCES

#ifdef NUCSYN_LOG_MPYIELDS
                        /*
                         * weird definition of yield - for single stars dmacc=0 and Xlose is
                         * Xenv so this is obvious - what it means for binaries is unclear
                         */
                        mpyield[i] += dy + dmp * XZAMS[i];
#endif //NUCSYN_LOG_MPYIELDS
                    }
                }  
            }

            /*
             * To get here, dmacc is non-zero.
             * If dmlose is zero, we only accrete.
             */
            else if(Is_zero(dmlose) && Xacc!=NULL)  
            {
                Dprint("dmlose = %g Is_zero, dmacc=%g\n",dmlose,dmacc);
                const double dmap = - dmacc * stardata->model.probability;
                
                // dmlose=0
#ifdef NUCSYN_ID_SOURCES
                Abundance * const Xsource = star->Xsource[source];
#endif
#ifdef NUCSYN_LOG_MPYIELDS
                const double dmp = dm*stardata->model.probability;
#endif

                Isotope_loop(i)
                {
                    //prefetch(Xacc+i+Isotope_loop_sign);
#if defined NUCSYN_ID_SOURCES || defined NUCSYN_LOG_MPYIELDS
                    const double dy = dmap * Xacc[i]; 
#else
#undef dy
#define dy ( dmap * Xacc[i] )
#endif
                    
                    Xyield[i] += dy;
#ifdef NUCSYN_ID_SOURCES
                    Xsource[i] += dy;
#endif

#ifdef NUCSYN_LOG_MPYIELDS
                    /*
                     * weird definition of yield - for single stars dmacc=0 and Xlose is
                     * Xenv so this is obvious - what it means for binaries is unclear
                     */
                    mpyield[i] += dy + dmp * XZAMS[i];
#endif
                }
            }
            else if(Xacc!=NULL && Xlose!=NULL)
            {
                /*
                 * General case : both dmacc and dmlose are 
                 * non-zero, but we require the X arrays to be non-NULL
                 */
#ifdef NUCSYN_ID_SOURCES
                Abundance * const Xsource = star->Xsource[source];
#endif
                const double dmlosep = dmlose * stardata->model.probability;
                const double dmaccp = dmacc * stardata->model.probability;
#ifdef NUCSYN_LOG_MPYIELDS
                const double dmp = dm*stardata->model.probability;
#endif
                Ordered_isotope_loop(i)
                {
                    /* calculate change in yield */
#if defined NUCSYN_ID_SOURCES || defined NUCSYN_LOG_MPYIELDS
                    const double dy = dmlosep * Xlose[i] - dmaccp * Xacc[i];
#else
#undef dy
#define dy  ( dmlosep * Xlose[i] - dmaccp * Xacc[i] )
#endif
#if defined NUCSYN_LOG_YIELDS_EVERY_TIMESTEP && \
    defined NUCSYN_LOG_INDIVIDUAL_DX_YIELDS
                    Printf("%0+.3e ",dy);
#endif
                   
                    /* calculate new yield from this change */
                    Xyield[i] += dy;
                    
#ifdef NUCSYN_ID_SOURCES
                    // save sourced yield
                    Xsource[i] += dy;
#endif
#ifdef NUCSYN_LOG_MPYIELDS
                    /*
                     * weird definition of yield - for single stars dmacc=0 and Xlose is
                     * Xenv so this is obvious - what it means for binaries is unclear
                     */
                    mpyield[i] += dy + dmp * XZAMS[i];
#endif
                }
            }

#ifdef NUCSYN_LOG_YIELDS_EVERY_TIMESTEP

#ifdef NUCSYN_LOG_INDIVIDUAL_DX_YIELDS
            Printf("\n");
#endif // NUCSYN_LOG_INDIVIDUAL_DX_YIELDS

#else
        
            if(final==YIELD_NOT_FINAL) return;

#endif // NUCSYN_LOG_YIELDS_EVERY_TIMESTEP

            
            
#ifdef NUCSYN_LOG_SINGLE_X_YIELDS
/* now log the yields */
            Printf("XYIELD%d__ ",starnum);
            Ordered_isotope_loop(i)
            {
                Printf("%0+.3e ",Xyield[i]);
            }
            Printf("\n");
#endif //NUCSYN_LOG_SINGLE_X_YIELDS

#ifdef NUCSYN_LOG_MPYIELDS
            Printf("MPYIELD%d__ ",starnum);
// Output p(i) !
            const double pmsm = star->pms_mass;
            Ordered_isotope_loop(i)
            {
                /* remember that to get the p(i) you must divide by the zams mass */
                Printf("%0+.3e ",mpyield[i]/pmsm);
            }
            Printf("\n");
#endif //NUCSYN_LOG_MPYIELDS

#ifdef NANCHECKS
            nancheck("nucsyn_calc_yields end",
                     star->Xyield,
                     ISOTOPE_ARRAY_SIZE);
#endif//NANCHECKS
        }
#endif /* NUCSYN_YIELDS */

}

#endif /* NUCSYN */
