#include "../binary_c.h"
/*
 * Reaction SIGMAV_PP H1(H1,beta)H2 
 * Alpha=H1, beta=H1, gamma=beta, delta=H2
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_DP H2(H1,gamma0)He3 
 * Alpha=H2, beta=H1, gamma=gamma0, delta=He3
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_He3_He3 He3(He3,2H1)He4 
 * Alpha=He3, beta=He3, gamma=H1, delta=He4
 * m=1, n=1, p=2, q=1
 */
/*
 * Reaction SIGMAV_He3_He4 He3(He4,gamma0)Be7 
 * Alpha=He3, beta=He4, gamma=gamma0, delta=Be7
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_Be7_e Be7(e,gamma0)Li7 
 * Alpha=Be7, beta=e, gamma=gamma0, delta=Li7
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_Be7_p Be7(H1,He4)He4 
 * Alpha=Be7, beta=H1, gamma=He4, delta=He4
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_Li7_p_alpha Li7(H1,He4)He4 
 * Alpha=Li7, beta=H1, gamma=He4, delta=He4
 * m=1, n=1, p=1, q=1
 */


#if defined NUCSYN && defined NUCSYN_NETWORK_PPfast
/* 
 * Network code : ppfast
 * Automatically generated by make_reaction_network_code.pl
 */

/*
 * Species / Reactions list:
 *
 * 1 : H1 :  +He3*He3*SIGMAV_He3_He3 +He4*He3*SIGMAV_He3_He4*SIGMAV_Be7_e/( -SIGMAV_Be7_e -H1*SIGMAV_Be7_p) -Be7*H1*SIGMAV_Be7_p -1.5*H1*H1*SIGMAV_PP
 * 2 : He3 :  -He3*He3*SIGMAV_He3_He3 -He4*He3*SIGMAV_He3_He4 +0.5*H1*H1*SIGMAV_PP
 * 3 : He4 :  +0.5*He3*He3*SIGMAV_He3_He3 -He4*He3*SIGMAV_He3_He4 -2*He4*He3*SIGMAV_He3_He4*SIGMAV_Be7_e/( -SIGMAV_Be7_e -H1*SIGMAV_Be7_p) +2*H1*Be7*SIGMAV_Be7_p
 * ...  H2 is assumed to be in equilibrium
 * ...  Li7 is assumed to be in equilibrium
 * ...  Be7 is assumed to be in equilibrium
 *
 */

static void ppfastjacobian(double ** RESTRICT const J,
                           const double * RESTRICT const N,
                           const double * RESTRICT const sigmav);
static void ppfastderivatives(const double * RESTRICT const y,
                              double * RESTRICT const dydt,
                              const double * RESTRICT const sigmav,
                              const double * RESTRICT const N);

double nucsyn_burn_ppfast (struct stardata_t * const stardata,
                           double * RESTRICT const Nin,
                           const double * RESTRICT const sigmav,
                           const double h)
{
    double err;
    unsigned int i;
    double *Jppfast[4];

    for(i=1;i<4;i++)
    {
        Jppfast[i]=Malloc(4*sizeof(double));
    }
    double yppfast[4],y2ppfast[4],f1ppfast[4],f2ppfast[4],f3ppfast[4],f4ppfast[4];
    int indxppfast[4];
    yppfast[1]=Nin[XH1];
    yppfast[2]=Nin[XHe3];
    yppfast[3]=Nin[XHe4];
    err=kaps_rentrop_GSL(h,yppfast,y2ppfast,3,Jppfast,sigmav,Nin,&ppfastjacobian,&ppfastderivatives,f1ppfast,f2ppfast,f3ppfast,f4ppfast,indxppfast);
    if(err<=1.0)
    {
        Nin[XH1]=yppfast[1];
        Nin[XHe3]=yppfast[2];
        Nin[XHe4]=yppfast[3];
        Nin[XH2] =   +0.5*Nin[XH1]*sigmav[SIGMAV_PP]/sigmav[SIGMAV_DP]; /* H2 in equilibrium */
        Nin[XLi7] =   +Nin[XBe7]*sigmav[SIGMAV_Be7_e]/sigmav[SIGMAV_Li7_p_alpha]/Nin[XH1]; /* Li7 in equilibrium */
        Nin[XBe7] =   -Nin[XHe3]*Nin[XHe4]*sigmav[SIGMAV_He3_He4]/( -sigmav[SIGMAV_Be7_e] -Nin[XH1]*sigmav[SIGMAV_Be7_p]); /* Be7 in equilibrium */
    }
    for(i=1;i<4;i++)
    {
        Safe_free(Jppfast[i]);
    }
    return(err);

}

static void ppfastderivatives(const double * RESTRICT const y,
                              double * RESTRICT const dydt,
                              const double * RESTRICT const sigmav,
                              const double * RESTRICT const N)
{
    const double dummy0=sigmav[SIGMAV_Be7_e] ;
    const double dummy1=y[2]*y[2]*sigmav[SIGMAV_He3_He3] ;
    const double dummy2=y[3]*y[2]*sigmav[SIGMAV_He3_He4] ;
    const double dummy3=y[1]*sigmav[SIGMAV_Be7_p] ;
    //const double dummy4=y[3]*y[2]*sigmav[SIGMAV_He3_He4]*sigmav[SIGMAV_Be7_e] ;
    const double dummy5=y[1]*y[1]*sigmav[SIGMAV_PP] ;
    dydt[1]=  + dummy1  + dummy2*dummy0/(  - dummy0  - dummy3)  - N[XBe7]*dummy3  - 1.5*dummy5;
    dydt[2]=  - dummy1  - dummy2  + 0.5*dummy5;
    dydt[3]=  + 0.5*dummy1  - dummy2  - 2.0*dummy2*dummy0/(  - dummy0  - dummy3)  + 2.0*y[1]*N[XBe7]*sigmav[SIGMAV_Be7_p];

}


//Jacobian



static void ppfastjacobian(double ** RESTRICT const J,
                           const double * RESTRICT const N,
                           const double * RESTRICT const sigmav)
{

    const double dummy0=N[XHe3]*sigmav[SIGMAV_He3_He3] ;
    const double dummy1=N[XH1]*sigmav[SIGMAV_PP] ;
    const double dummy2=N[XBe7]*sigmav[SIGMAV_Be7_p] ;
    const double dummy3=N[XHe3]*N[XHe4]*sigmav[SIGMAV_Be7_p]*sigmav[SIGMAV_He3_He4]*sigmav[SIGMAV_Be7_e] ;
    const double dummy4=sigmav[SIGMAV_Be7_e] ;
    //const double dummy5=N[XHe4]*sigmav[SIGMAV_He3_He4]*sigmav[SIGMAV_Be7_e] ;
    const double dummy6=N[XHe4]*sigmav[SIGMAV_He3_He4] ;
    const double dummy7=N[XHe3]*sigmav[SIGMAV_He3_He4] ;
    //const double dummy8=N[XHe3]*sigmav[SIGMAV_He3_He4]*sigmav[SIGMAV_Be7_e] ;
    const double dummy9=N[XH1]*N[XH1]*sigmav[SIGMAV_Be7_p]*sigmav[SIGMAV_Be7_p] ;
    //const double dummy10=N[XH1]*sigmav[SIGMAV_Be7_p]*sigmav[SIGMAV_Be7_e] ;
    const double dummy11=N[XH1]*sigmav[SIGMAV_Be7_p] ;
    //const double dummy12=sigmav[SIGMAV_Be7_e]*sigmav[SIGMAV_Be7_e] ;
    J[1][1] =   + dummy3/(2*dummy11*dummy4  + dummy4*dummy4  + dummy9)  - dummy2  - 3.0*dummy1;
    J[2][1] =   + dummy1;
    J[3][1] =   - 2.0*dummy3/(2*dummy11*dummy4  + dummy4*dummy4  + dummy9)  + 2.0*dummy2;
    J[1][2] =   + 2.0*dummy0  + dummy6*dummy4/(  - dummy4  - dummy11);
    J[2][2] =   - dummy6  - 2.0*dummy0;
    J[3][2] =   + dummy0  - dummy6  - 2.0*dummy6*dummy4/(  - dummy4  - dummy11);
    J[1][3] =   + dummy7*dummy4/(  - dummy4  - dummy11);
    J[2][3] =   - dummy7;
    J[3][3] =   - dummy7  - 2.0*dummy7*dummy4/(  - dummy4  - dummy11);

}


#endif
