#include "../binary_c.h"

#if defined NUCSYN && defined NUCSYN_NETWORK_PP
/* 
 * Network code : pp
 * Automatically generated by make_reaction_network_code.pl
 */

/*
 * Reaction SIGMAV_PP H1(H1,beta)H2 
 * Alpha=H1, beta=H1, gamma=beta, delta=H2
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_DP H2(H1,gamma0)He3 
 * Alpha=H2, beta=H1, gamma=gamma0, delta=He3
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_He3_He3 He3(He3,2H1)He4 
 * Alpha=He3, beta=He3, gamma=H1, delta=He4
 * m=1, n=1, p=2, q=1
 */
/*
 * Reaction SIGMAV_He3_He4 He3(He4,gamma0)Be7 
 * Alpha=He3, beta=He4, gamma=gamma0, delta=Be7
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_Be7_e Be7(e,gamma0)Li7 
 * Alpha=Be7, beta=e, gamma=gamma0, delta=Li7
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_Be7_p Be7(H1,He4)He4 
 * Alpha=Be7, beta=H1, gamma=He4, delta=He4
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_Li7_p_alpha Li7(H1,He4)He4 
 * Alpha=Li7, beta=H1, gamma=He4, delta=He4
 * m=1, n=1, p=1, q=1
 */


/*
 * Species / Reactions list:
 *
 * 1 : H1 : -H1*H1*SIGMAV_PP -H2*H1*SIGMAV_DP +He3*He3*SIGMAV_He3_He3 -Be7*H1*SIGMAV_Be7_p -Li7*H1*SIGMAV_Li7_p_alpha 
 * 2 : H2 : +0.5*H1*H1*SIGMAV_PP -H2*H1*SIGMAV_DP 
 * 3 : He3 : +H2*H1*SIGMAV_DP -He3*He3*SIGMAV_He3_He3 -He3*He4*SIGMAV_He3_He4 
 * 4 : He4 : +0.5*He3*He3*SIGMAV_He3_He3 -He3*He4*SIGMAV_He3_He4 +2*Be7*H1*SIGMAV_Be7_p +2*Li7*H1*SIGMAV_Li7_p_alpha 
 * 5 : Li7 : +Be7*e*SIGMAV_Be7_e -Li7*H1*SIGMAV_Li7_p_alpha 
 * 6 : Be7 : +He3*He4*SIGMAV_He3_He4 -Be7*e*SIGMAV_Be7_e -Be7*H1*SIGMAV_Be7_p 
 *
 */



static void ppjacobian(double ** RESTRICT const J,
                       const double * RESTRICT const N,
                       const double * RESTRICT const sigmav);
static void ppderivatives(const double * RESTRICT const y,
                   double * RESTRICT const dydt,
                   const double * RESTRICT const sigmav,
                   const double * RESTRICT const N);

double nucsyn_burn_pp (double * RESTRICT const Nin,
                       const double * RESTRICT const sigmav,
                       const double h)
{
    double err;
    unsigned int i;
    double *Jpp[7];

    for(i=1;i<7;i++)
    {
        Jpp[i]=Malloc(7*sizeof(double));
    }
    double ypp[7],y2pp[7],f1pp[7],f2pp[7],f3pp[7],f4pp[7];
    int indxpp[7];

    /* increase Be7 e-capture rate by electron density: saves putting it in the matrices */ 
    //make sure this code is in the function which calls this function//const double edens=nucsyn_free_electron_density(Nin,stardata->store->atomic_number);
    //sigmav[SIGMAV_Be7_e]*=edens;

    ypp[1]=Nin[XH1];
    ypp[2]=Nin[XH2];
    ypp[3]=Nin[XHe3];
    ypp[4]=Nin[XHe4];
    ypp[5]=Nin[XLi7];
    ypp[6]=Nin[XBe7];
    err=kaps_rentrop_GSL(h,ypp,y2pp,6,Jpp,sigmav,Nin,&ppjacobian,&ppderivatives,f1pp,f2pp,f3pp,f4pp,indxpp);
    if(err<=1.0)
    {
        Nin[XH1]=ypp[1];
        Nin[XH2]=ypp[2];
        Nin[XHe3]=ypp[3];
        Nin[XHe4]=ypp[4];
        Nin[XLi7]=ypp[5];
        Nin[XBe7]=ypp[6];
    }
    /* decrease Be7 rate back to what it should be */ 
    //sigmav[SIGMAV_Be7_e]/=edens;
    for(i=1;i<7;i++)
    { 
        Safe_free(Jpp[i]);
    }
    return(err);
}

static void ppderivatives(const double * RESTRICT const y,
                          double * RESTRICT const dydt,
                          const double * RESTRICT const sigmav,
                          const double * RESTRICT const N)
{
    const double dummy0=y[6]*sigmav[SIGMAV_Be7_e] ;
    const double dummy1=y[5]*y[1]*sigmav[SIGMAV_Li7_p_alpha] ;
    const double dummy2=y[6]*y[1]*sigmav[SIGMAV_Be7_p] ;
    const double dummy3=y[2]*y[1]*sigmav[SIGMAV_DP] ;
    const double dummy4=y[3]*y[3]*sigmav[SIGMAV_He3_He3] ;
    const double dummy5=y[3]*y[4]*sigmav[SIGMAV_He3_He4] ;
    const double dummy6=y[1]*y[1]*sigmav[SIGMAV_PP] ;
    dydt[1]= - dummy6  - dummy3  + dummy4  - dummy2  - dummy1 ;
    dydt[2]= + 0.5*dummy6  - dummy3 ;
    dydt[3]= + dummy3  - dummy4  - dummy5 ;
    dydt[4]= + 0.5*dummy4  - dummy5  + 2.0*dummy2  + 2.0*dummy1 ;
    dydt[5]= + dummy0  - dummy1 ;
    dydt[6]= + dummy5  - dummy0  - dummy2 ;

}


//Jacobian



static void ppjacobian(double ** RESTRICT const J,
                       const double * RESTRICT const N,
                       const double * RESTRICT const sigmav)
{

    const double dummy0=N[XHe3]*sigmav[SIGMAV_He3_He3] ;
    const double dummy1=N[XH1]*sigmav[SIGMAV_PP] ;
    const double dummy2=N[XBe7]*sigmav[SIGMAV_Be7_p] ;
    const double dummy3=sigmav[SIGMAV_Be7_e] ;
    const double dummy4=N[XH2]*sigmav[SIGMAV_DP] ;
    const double dummy5=N[XHe4]*sigmav[SIGMAV_He3_He4] ;
    const double dummy6=N[XHe3]*sigmav[SIGMAV_He3_He4] ;
    const double dummy7=N[XH1]*sigmav[SIGMAV_Be7_p] ;
    const double dummy8=N[XLi7]*sigmav[SIGMAV_Li7_p_alpha] ;
    const double dummy9=N[XH1]*sigmav[SIGMAV_Li7_p_alpha] ;
    const double dummy10=N[XH1]*sigmav[SIGMAV_DP] ;
    J[1][1] =   - dummy4  - dummy8  - dummy2  - 2.0*dummy1;
    J[1][2] =   - dummy10;
    J[1][3] =   + 2.0*dummy0;
    J[1][4] = 0.0;
    J[1][5] =   - dummy9;
    J[1][6] =   - dummy7;
    J[2][1] =   + dummy1  - dummy4;
    J[2][2] =   - dummy10;
    J[2][3] = 0.0;
    J[2][4] = 0.0;
    J[2][5] = 0.0;
    J[2][6] = 0.0;
    J[3][1] =   + dummy4;
    J[3][2] =   + dummy10;
    J[3][3] =   - 2.0*dummy0  - dummy5;
    J[3][4] =   - dummy6;
    J[3][5] = 0.0;
    J[3][6] = 0.0;
    J[4][1] =   + 2.0*dummy8  + 2.0*dummy2;
    J[4][2] = 0.0;
    J[4][3] =   - dummy5  + dummy0;
    J[4][4] =   - dummy6;
    J[4][5] =   + 2.0*dummy9;
    J[4][6] =   + 2.0*dummy7;
    J[5][1] =   - dummy8;
    J[5][2] = 0.0;
    J[5][3] = 0.0;
    J[5][4] = 0.0;
    J[5][5] =   - dummy9;
    J[5][6] =   + dummy3;
    J[6][1] =   - dummy2;
    J[6][2] = 0.0;
    J[6][3] =   + dummy5;
    J[6][4] =   + dummy6;
    J[6][5] = 0.0;
    J[6][6] =   - dummy3  - dummy7;
}

#endif

