#include "../binary_c.h"

#if defined NUCSYN && defined NUCSYN_NETWORK_HOTCNO

/* 
 * Network code : hotCNO
 * Automatically generated by make_reaction_network_code.pl
 */

/*
 * Species / Reactions list:
 *
 * 1 : H1 : -C12*H1*SIGMAV_T12 -C13*H1*SIGMAV_T13 -N13*H1*SIGMAV_TPN13 -N14*H1*SIGMAV_T14 -N15*H1*SIGMAV_T15 -N15*H1*SIGMAV_T15_BRANCH -O16*H1*SIGMAV_T16 -O17*H1*SIGMAV_T17 -O17*H1*SIGMAV_O17G -O18*H1*SIGMAV_O18A -O18*H1*SIGMAV_O18G -F19*H1*SIGMAV_F19A 
 * 2 : He4 : +N15*H1*SIGMAV_T15 +O17*H1*SIGMAV_T17 +O18*H1*SIGMAV_O18A +F19*H1*SIGMAV_F19A 
 * 3 : C12 : -C12*H1*SIGMAV_T12 +N15*H1*SIGMAV_T15 
 * 4 : N13 : +C12*H1*SIGMAV_T12 -N13*beta*SIGMAV_TBETA13 -N13*H1*SIGMAV_TPN13 
 * 5 : C13 : +N13*beta*SIGMAV_TBETA13 -C13*H1*SIGMAV_T13 
 * 6 : O14 : +N13*H1*SIGMAV_TPN13 -O14*beta*SIGMAV_TO14BETA 
 * 7 : N14 : +C13*H1*SIGMAV_T13 +O14*beta*SIGMAV_TO14BETA -N14*H1*SIGMAV_T14 +O17*H1*SIGMAV_T17 
 * 8 : O15 : +N14*H1*SIGMAV_T14 -O15*beta*SIGMAV_TBETA15 
 * 9 : N15 : +O15*beta*SIGMAV_TBETA15 -N15*H1*SIGMAV_T15 -N15*H1*SIGMAV_T15_BRANCH +O18*H1*SIGMAV_O18A 
 * 10 : O16 : +N15*H1*SIGMAV_T15_BRANCH -O16*H1*SIGMAV_T16 +F19*H1*SIGMAV_F19A 
 * 11 : O17 : +F17*beta*SIGMAV_TBETA17 -O17*H1*SIGMAV_T17 -O17*H1*SIGMAV_O17G 
 * 12 : F17 : +O16*H1*SIGMAV_T16 -F17*beta*SIGMAV_TBETA17 
 * 13 : O18 : +F18*beta*SIGMAV_F18BETA -O18*H1*SIGMAV_O18A -O18*H1*SIGMAV_O18G 
 * 14 : F18 : +O17*H1*SIGMAV_O17G -F18*beta*SIGMAV_F18BETA 
 * 15 : F19 : +O18*H1*SIGMAV_O18G -F19*H1*SIGMAV_F19A 
 *
 */

static void hotCNOjacobian(double ** RESTRICT const J,
                           const double * RESTRICT const N,
                           const double * RESTRICT const sigmav);
static void hotCNOderivatives(const double * RESTRICT const y,
                              double * RESTRICT const dydt,
                              const double * RESTRICT const sigmav,
                              const double * RESTRICT const N);

double nucsyn_burn_hotCNO (double * RESTRICT const Nin,
                           const double * RESTRICT const sigmav,
                           const double h)
{
    double err;
    unsigned int i;
    for(i=1;i<16;i++)
    {
        JhotCNO[i]=Malloc(16*sizeof(double));
    }

    double yhotCNO[16],y2hotCNO[16],f1hotCNO[16],f2hotCNO[16],f3hotCNO[16],f4hotCNO[16];
    int indxhotCNO[16];

    yhotCNO[1]=Nin[XH1];
    yhotCNO[2]=Nin[XHe4];
    yhotCNO[3]=Nin[XC12];
    yhotCNO[4]=Nin[XN13];
    yhotCNO[5]=Nin[XC13];
    yhotCNO[6]=Nin[XO14];
    yhotCNO[7]=Nin[XN14];
    yhotCNO[8]=Nin[XO15];
    yhotCNO[9]=Nin[XN15];
    yhotCNO[10]=Nin[XO16];
    yhotCNO[11]=Nin[XO17];
    yhotCNO[12]=Nin[XF17];
    yhotCNO[13]=Nin[XO18];
    yhotCNO[14]=Nin[XF18];
    yhotCNO[15]=Nin[XF19];
    err=kaps_rentrop_GSL(h,yhotCNO,y2hotCNO,15,JhotCNO,sigmav,Nin,&hotCNOjacobian,&hotCNOderivatives,f1hotCNO,f2hotCNO,f3hotCNO,f4hotCNO,indxhotCNO);
    if(err<=1.0)
    {
        Nin[XH1]=yhotCNO[1];
        Nin[XHe4]=yhotCNO[2];
        Nin[XC12]=yhotCNO[3];
        Nin[XN13]=yhotCNO[4];
        Nin[XC13]=yhotCNO[5];
        Nin[XO14]=yhotCNO[6];
        Nin[XN14]=yhotCNO[7];
        Nin[XO15]=yhotCNO[8];
        Nin[XN15]=yhotCNO[9];
        Nin[XO16]=yhotCNO[10];
        Nin[XO17]=yhotCNO[11];
        Nin[XF17]=yhotCNO[12];
        Nin[XO18]=yhotCNO[13];
        Nin[XF18]=yhotCNO[14];
        Nin[XF19]=yhotCNO[15];
    }
    for(i=1;i<16;i++)
    { 
        Safe_free(JhotCNO[i]);
    }
    return(err);

}
static void hotCNOderivatives(const double * RESTRICT const y,
                              double * RESTRICT const dydt,
                              const double * RESTRICT const sigmav,
                              const double * RESTRICT const N)
{
    double dummy0=y[9]*y[1]*sigmav[SIGMAV_T15] ;
    double dummy1=y[11]*y[1]*sigmav[SIGMAV_T17] ;
    double dummy2=y[4]/sigmav[SIGMAV_TBETA13] ;
    double dummy3=y[10]*y[1]*sigmav[SIGMAV_T16] ;
    double dummy4=y[13]*y[1]*sigmav[SIGMAV_O18G] ;
    double dummy5=y[11]*y[1]*sigmav[SIGMAV_O17G] ;
    double dummy6=y[7]*y[1]*sigmav[SIGMAV_T14] ;
    double dummy7=y[9]*y[1]*sigmav[SIGMAV_T15_BRANCH] ;
    double dummy8=y[14]/sigmav[SIGMAV_F18BETA] ;
    double dummy9=y[6]/sigmav[SIGMAV_TO14BETA] ;
    double dummy10=y[4]*y[1]*sigmav[SIGMAV_TPN13] ;
    double dummy11=y[5]*y[1]*sigmav[SIGMAV_T13] ;
    double dummy12=y[8]/sigmav[SIGMAV_TBETA15] ;
    double dummy13=y[3]*y[1]*sigmav[SIGMAV_T12] ;
    double dummy14=y[13]*y[1]*sigmav[SIGMAV_O18A] ;
    double dummy15=y[15]*y[1]*sigmav[SIGMAV_F19A] ;
    double dummy16=y[12]/sigmav[SIGMAV_TBETA17] ;
    dydt[1]= - dummy13  - dummy11  - dummy10  - dummy6  - dummy0  - dummy7  - dummy3  - dummy1  - dummy5  - dummy14  - dummy4  - dummy15 ;
    dydt[2]= + dummy0  + dummy1  + dummy14  + dummy15 ;
    dydt[3]= - dummy13  + dummy0 ;
    dydt[4]= + dummy13  - dummy2  - dummy10 ;
    dydt[5]= + dummy2  - dummy11 ;
    dydt[6]= + dummy10  - dummy9 ;
    dydt[7]= + dummy11  + dummy9  - dummy6  + dummy1 ;
    dydt[8]= + dummy6  - dummy12 ;
    dydt[9]= + dummy12  - dummy0  - dummy7  + dummy14 ;
    dydt[10]= + dummy7  - dummy3  + dummy15 ;
    dydt[11]= + dummy16  - dummy1  - dummy5 ;
    dydt[12]= + dummy3  - dummy16 ;
    dydt[13]= + dummy8  - dummy14  - dummy4 ;
    dydt[14]= + dummy5  - dummy8 ;
    dydt[15]= + dummy4  - dummy15 ;

}


//Jacobian



static void hotCNOjacobian(double ** RESTRICT const J,
                           const double * RESTRICT const N,
                           const double * RESTRICT const sigmav)
{

    double dummy0=1.0/sigmav[SIGMAV_F18BETA] ;
    double dummy1=N[XF19]*sigmav[SIGMAV_F19A] ;
    double dummy2=N[XO16]*sigmav[SIGMAV_T16] ;
    double dummy3=N[XH1]*sigmav[SIGMAV_T14] ;
    double dummy4=N[XO17]*sigmav[SIGMAV_O17G] ;
    double dummy5=N[XH1]*sigmav[SIGMAV_T16] ;
    double dummy6=N[XO18]*sigmav[SIGMAV_O18G] ;
    double dummy7=N[XN13]*sigmav[SIGMAV_TPN13] ;
    double dummy8=1.0/sigmav[SIGMAV_TO14BETA] ;
    double dummy9=N[XH1]*sigmav[SIGMAV_T17] ;
    double dummy10=N[XH1]*sigmav[SIGMAV_T13] ;
    double dummy11=N[XH1]*sigmav[SIGMAV_O18A] ;
    double dummy12=N[XH1]*sigmav[SIGMAV_O18G] ;
    double dummy13=N[XN15]*sigmav[SIGMAV_T15_BRANCH] ;
    double dummy14=N[XN15]*sigmav[SIGMAV_T15] ;
    double dummy15=N[XH1]*sigmav[SIGMAV_O17G] ;
    double dummy16=N[XH1]*sigmav[SIGMAV_TPN13] ;
    double dummy17=N[XO17]*sigmav[SIGMAV_T17] ;
    double dummy18=N[XH1]*sigmav[SIGMAV_F19A] ;
    double dummy19=1.0/sigmav[SIGMAV_TBETA15] ;
    double dummy20=N[XC13]*sigmav[SIGMAV_T13] ;
    double dummy21=N[XH1]*sigmav[SIGMAV_T15_BRANCH] ;
    double dummy22=N[XO18]*sigmav[SIGMAV_O18A] ;
    double dummy23=N[XH1]*sigmav[SIGMAV_T12] ;
    double dummy24=N[XN14]*sigmav[SIGMAV_T14] ;
    double dummy25=1.0/sigmav[SIGMAV_TBETA17] ;
    double dummy26=N[XH1]*sigmav[SIGMAV_T15] ;
    double dummy27=N[XC12]*sigmav[SIGMAV_T12] ;
    double dummy28=1.0/sigmav[SIGMAV_TBETA13] ;
    J[1][1] =  - dummy27  - dummy20  - dummy7  - dummy24  - dummy14  - dummy13  - dummy2  - dummy17  - dummy4  - dummy22  - dummy6  - dummy1 ;
    J[2][1] =  + dummy14  + dummy17  + dummy22  + dummy1 ;
    J[3][1] =  - dummy27  + dummy14 ;
    J[4][1] =  + dummy27  - dummy7 ;
    J[5][1] =  - dummy20 ;
    J[6][1] =  + dummy7 ;
    J[7][1] =  + dummy20  - dummy24  + dummy17 ;
    J[8][1] =  + dummy24 ;
    J[9][1] =  - dummy14  - dummy13  + dummy22 ;
    J[10][1] =  + dummy13  - dummy2  + dummy1 ;
    J[11][1] =  - dummy17  - dummy4 ;
    J[12][1] =  + dummy2 ;
    J[13][1] =  - dummy22  - dummy6 ;
    J[14][1] =  + dummy4 ;
    J[15][1] =  + dummy6  - dummy1 ;
    J[1][2] = 0.0;
    J[2][2] = 0.0;
    J[3][2] = 0.0;
    J[4][2] = 0.0;
    J[5][2] = 0.0;
    J[6][2] = 0.0;
    J[7][2] = 0.0;
    J[8][2] = 0.0;
    J[9][2] = 0.0;
    J[10][2] = 0.0;
    J[11][2] = 0.0;
    J[12][2] = 0.0;
    J[13][2] = 0.0;
    J[14][2] = 0.0;
    J[15][2] = 0.0;
    J[1][3] =  - dummy23 ;
    J[2][3] = 0.0;
    J[3][3] =  - dummy23 ;
    J[4][3] =  + dummy23 ;
    J[5][3] = 0.0;
    J[6][3] = 0.0;
    J[7][3] = 0.0;
    J[8][3] = 0.0;
    J[9][3] = 0.0;
    J[10][3] = 0.0;
    J[11][3] = 0.0;
    J[12][3] = 0.0;
    J[13][3] = 0.0;
    J[14][3] = 0.0;
    J[15][3] = 0.0;
    J[1][4] =  - dummy16 ;
    J[2][4] = 0.0;
    J[3][4] = 0.0;
    J[4][4] =  - dummy28  - dummy16 ;
    J[5][4] =  + dummy28 ;
    J[6][4] =  + dummy16 ;
    J[7][4] = 0.0;
    J[8][4] = 0.0;
    J[9][4] = 0.0;
    J[10][4] = 0.0;
    J[11][4] = 0.0;
    J[12][4] = 0.0;
    J[13][4] = 0.0;
    J[14][4] = 0.0;
    J[15][4] = 0.0;
    J[1][5] =  - dummy10 ;
    J[2][5] = 0.0;
    J[3][5] = 0.0;
    J[4][5] = 0.0;
    J[5][5] =  - dummy10 ;
    J[6][5] = 0.0;
    J[7][5] =  + dummy10 ;
    J[8][5] = 0.0;
    J[9][5] = 0.0;
    J[10][5] = 0.0;
    J[11][5] = 0.0;
    J[12][5] = 0.0;
    J[13][5] = 0.0;
    J[14][5] = 0.0;
    J[15][5] = 0.0;
    J[1][6] = 0.0;
    J[2][6] = 0.0;
    J[3][6] = 0.0;
    J[4][6] = 0.0;
    J[5][6] = 0.0;
    J[6][6] =  - dummy8 ;
    J[7][6] =  + dummy8 ;
    J[8][6] = 0.0;
    J[9][6] = 0.0;
    J[10][6] = 0.0;
    J[11][6] = 0.0;
    J[12][6] = 0.0;
    J[13][6] = 0.0;
    J[14][6] = 0.0;
    J[15][6] = 0.0;
    J[1][7] =  - dummy3 ;
    J[2][7] = 0.0;
    J[3][7] = 0.0;
    J[4][7] = 0.0;
    J[5][7] = 0.0;
    J[6][7] = 0.0;
    J[7][7] =  - dummy3 ;
    J[8][7] =  + dummy3 ;
    J[9][7] = 0.0;
    J[10][7] = 0.0;
    J[11][7] = 0.0;
    J[12][7] = 0.0;
    J[13][7] = 0.0;
    J[14][7] = 0.0;
    J[15][7] = 0.0;
    J[1][8] = 0.0;
    J[2][8] = 0.0;
    J[3][8] = 0.0;
    J[4][8] = 0.0;
    J[5][8] = 0.0;
    J[6][8] = 0.0;
    J[7][8] = 0.0;
    J[8][8] =  - dummy19 ;
    J[9][8] =  + dummy19 ;
    J[10][8] = 0.0;
    J[11][8] = 0.0;
    J[12][8] = 0.0;
    J[13][8] = 0.0;
    J[14][8] = 0.0;
    J[15][8] = 0.0;
    J[1][9] =  - dummy26  - dummy21 ;
    J[2][9] =  + dummy26 ;
    J[3][9] =  + dummy26 ;
    J[4][9] = 0.0;
    J[5][9] = 0.0;
    J[6][9] = 0.0;
    J[7][9] = 0.0;
    J[8][9] = 0.0;
    J[9][9] =  - dummy26  - dummy21 ;
    J[10][9] =  + dummy21 ;
    J[11][9] = 0.0;
    J[12][9] = 0.0;
    J[13][9] = 0.0;
    J[14][9] = 0.0;
    J[15][9] = 0.0;
    J[1][10] =  - dummy5 ;
    J[2][10] = 0.0;
    J[3][10] = 0.0;
    J[4][10] = 0.0;
    J[5][10] = 0.0;
    J[6][10] = 0.0;
    J[7][10] = 0.0;
    J[8][10] = 0.0;
    J[9][10] = 0.0;
    J[10][10] =  - dummy5 ;
    J[11][10] = 0.0;
    J[12][10] =  + dummy5 ;
    J[13][10] = 0.0;
    J[14][10] = 0.0;
    J[15][10] = 0.0;
    J[1][11] =  - dummy9  - dummy15 ;
    J[2][11] =  + dummy9 ;
    J[3][11] = 0.0;
    J[4][11] = 0.0;
    J[5][11] = 0.0;
    J[6][11] = 0.0;
    J[7][11] =  + dummy9 ;
    J[8][11] = 0.0;
    J[9][11] = 0.0;
    J[10][11] = 0.0;
    J[11][11] =  - dummy9  - dummy15 ;
    J[12][11] = 0.0;
    J[13][11] = 0.0;
    J[14][11] =  + dummy15 ;
    J[15][11] = 0.0;
    J[1][12] = 0.0;
    J[2][12] = 0.0;
    J[3][12] = 0.0;
    J[4][12] = 0.0;
    J[5][12] = 0.0;
    J[6][12] = 0.0;
    J[7][12] = 0.0;
    J[8][12] = 0.0;
    J[9][12] = 0.0;
    J[10][12] = 0.0;
    J[11][12] =  + dummy25 ;
    J[12][12] =  - dummy25 ;
    J[13][12] = 0.0;
    J[14][12] = 0.0;
    J[15][12] = 0.0;
    J[1][13] =  - dummy11  - dummy12 ;
    J[2][13] =  + dummy11 ;
    J[3][13] = 0.0;
    J[4][13] = 0.0;
    J[5][13] = 0.0;
    J[6][13] = 0.0;
    J[7][13] = 0.0;
    J[8][13] = 0.0;
    J[9][13] =  + dummy11 ;
    J[10][13] = 0.0;
    J[11][13] = 0.0;
    J[12][13] = 0.0;
    J[13][13] =  - dummy11  - dummy12 ;
    J[14][13] = 0.0;
    J[15][13] =  + dummy12 ;
    J[1][14] = 0.0;
    J[2][14] = 0.0;
    J[3][14] = 0.0;
    J[4][14] = 0.0;
    J[5][14] = 0.0;
    J[6][14] = 0.0;
    J[7][14] = 0.0;
    J[8][14] = 0.0;
    J[9][14] = 0.0;
    J[10][14] = 0.0;
    J[11][14] = 0.0;
    J[12][14] = 0.0;
    J[13][14] =  + dummy0 ;
    J[14][14] =  - dummy0 ;
    J[15][14] = 0.0;
    J[1][15] =  - dummy18 ;
    J[2][15] =  + dummy18 ;
    J[3][15] = 0.0;
    J[4][15] = 0.0;
    J[5][15] = 0.0;
    J[6][15] = 0.0;
    J[7][15] = 0.0;
    J[8][15] = 0.0;
    J[9][15] = 0.0;
    J[10][15] =  + dummy18 ;
    J[11][15] = 0.0;
    J[12][15] = 0.0;
    J[13][15] = 0.0;
    J[14][15] = 0.0;
    J[15][15] =  - dummy18 ;

}


#endif
