
#include "../binary_c.h"

#if defined NUCSYN && defined NUCSYN_NETWORK_COLDCNO

/* 
 * Network code : coldCNO
 * Automatically generated by make_reaction_network_code.pl
 */

/*
 * Reaction SIGMAV_T12 C12(H1,gamma0)C13
 * Alpha=C12, beta=H1, gamma=gamma0, delta=C13
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_T13 C13(H1,gamma0)N14
 * Alpha=C13, beta=H1, gamma=gamma0, delta=N14
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_T14 N14(H1,gamma0)N15
 * Alpha=N14, beta=H1, gamma=gamma0, delta=N15
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_T15 N15(H1,He4)C12
 * Alpha=N15, beta=H1, gamma=He4, delta=C12
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_T15_BRANCH N15(H1,gamma0)O16
 * Alpha=N15, beta=H1, gamma=gamma0, delta=O16
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_T16 O16(H1,gamma0)O17
 * Alpha=O16, beta=H1, gamma=gamma0, delta=O17
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_T17 O17(H1,He4)N14
 * Alpha=O17, beta=H1, gamma=He4, delta=N14
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_O17G O17(H1,gamma0)O18
 * Alpha=O17, beta=H1, gamma=gamma0, delta=O18
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_O18A O18(H1,He4)N15
 * Alpha=O18, beta=H1, gamma=He4, delta=N15
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_O18G O18(H1,gamma0)F19
 * Alpha=O18, beta=H1, gamma=gamma0, delta=F19
 * m=1, n=1, p=1, q=1
 */
/*
 * Reaction SIGMAV_F19A F19(H1,He4)O16
 * Alpha=F19, beta=H1, gamma=He4, delta=O16
 * m=1, n=1, p=1, q=1
 */


/*
 * Species / Reactions list:
 *
 * 1 : H1 : -C12*H1*SIGMAV_T12 -C13*H1*SIGMAV_T13 -N14*H1*SIGMAV_T14 -N15*H1*SIGMAV_T15 -N15*H1*SIGMAV_T15_BRANCH -O16*H1*SIGMAV_T16 -O17*H1*SIGMAV_T17 -O17*H1*SIGMAV_O17G -O18*H1*SIGMAV_O18A -O18*H1*SIGMAV_O18G -F19*H1*SIGMAV_F19A 
 * 2 : He4 : +N15*H1*SIGMAV_T15 +O17*H1*SIGMAV_T17 +O18*H1*SIGMAV_O18A +F19*H1*SIGMAV_F19A 
 * 3 : C12 : -C12*H1*SIGMAV_T12 +N15*H1*SIGMAV_T15 
 * 4 : C13 : +C12*H1*SIGMAV_T12 -C13*H1*SIGMAV_T13 
 * 5 : N14 : +C13*H1*SIGMAV_T13 -N14*H1*SIGMAV_T14 +O17*H1*SIGMAV_T17 
 * 6 : N15 : +N14*H1*SIGMAV_T14 -N15*H1*SIGMAV_T15 -N15*H1*SIGMAV_T15_BRANCH +O18*H1*SIGMAV_O18A 
 * 7 : O16 : +N15*H1*SIGMAV_T15_BRANCH -O16*H1*SIGMAV_T16 +F19*H1*SIGMAV_F19A 
 * 8 : O17 : +O16*H1*SIGMAV_T16 -O17*H1*SIGMAV_T17 -O17*H1*SIGMAV_O17G 
 * 9 : O18 : +O17*H1*SIGMAV_O17G -O18*H1*SIGMAV_O18A -O18*H1*SIGMAV_O18G 
 * 10 : F19 : +O18*H1*SIGMAV_O18G -F19*H1*SIGMAV_F19A 
 *
 */

static void coldCNOjacobian(double ** RESTRICT const J,
                            const double * RESTRICT const N,
                            const double * RESTRICT const sigmav);
static void coldCNOderivatives(const double * RESTRICT const y,
                               double * RESTRICT const dydt,
                               const double * RESTRICT const sigmav,
                               const double * RESTRICT const N);

double nucsyn_burn_coldCNO (double * RESTRICT const Nin,
                            const double * RESTRICT const sigmav,
                            const double h)
{
    double err;
    unsigned int i;
    double *JcoldCNO[11];

    for(i=1;i<11;i++)
    {
        JcoldCNO[i]=Malloc(11*sizeof(double));
    }
   

    double
        ycoldCNO[11],
        y2coldCNO[11],
        f1coldCNO[11],
        f2coldCNO[11],
        f3coldCNO[11],
        f4coldCNO[11];
    int indxcoldCNO[11];
    ycoldCNO[1]=Nin[XH1];
    ycoldCNO[2]=Nin[XHe4];
    ycoldCNO[3]=Nin[XC12];
    ycoldCNO[4]=Nin[XC13];
    ycoldCNO[5]=Nin[XN14];
    ycoldCNO[6]=Nin[XN15];
    ycoldCNO[7]=Nin[XO16];
    ycoldCNO[8]=Nin[XO17];
    ycoldCNO[9]=Nin[XO18];
    ycoldCNO[10]=Nin[XF19];
    err=kaps_rentrop_GSL(h,ycoldCNO,y2coldCNO,10,JcoldCNO,sigmav,Nin,&coldCNOjacobian,&coldCNOderivatives,f1coldCNO,f2coldCNO,f3coldCNO,f4coldCNO,indxcoldCNO);
    if(err<=1.0)
    {
        Nin[XH1]=ycoldCNO[1];
        Nin[XHe4]=ycoldCNO[2];
        Nin[XC12]=ycoldCNO[3];
        Nin[XC13]=ycoldCNO[4];
        Nin[XN14]=ycoldCNO[5];
        Nin[XN15]=ycoldCNO[6];
        Nin[XO16]=ycoldCNO[7];
        Nin[XO17]=ycoldCNO[8];
        Nin[XO18]=ycoldCNO[9];
        Nin[XF19]=ycoldCNO[10];
    }
    for(i=1;i<11;i++)
    { 
        Safe_free(JcoldCNO[i]);
    }
    return(err);

}
static void coldCNOderivatives(const double * RESTRICT const y,
                               double * RESTRICT const dydt,
                               const double * RESTRICT const sigmav,
                               const double * RESTRICT const N)
{
    const double dummy0=y[9]*y[1]*sigmav[SIGMAV_O18G] ;
    const double dummy1=y[6]*y[1]*sigmav[SIGMAV_T15] ;
    const double dummy2=y[8]*y[1]*sigmav[SIGMAV_T17] ;
    const double dummy3=y[9]*y[1]*sigmav[SIGMAV_O18A] ;
    const double dummy4=y[7]*y[1]*sigmav[SIGMAV_T16] ;
    const double dummy5=y[4]*y[1]*sigmav[SIGMAV_T13] ;
    const double dummy6=y[10]*y[1]*sigmav[SIGMAV_F19A] ;
    const double dummy7=y[3]*y[1]*sigmav[SIGMAV_T12] ;
    const double dummy8=y[5]*y[1]*sigmav[SIGMAV_T14] ;
    const double dummy9=y[6]*y[1]*sigmav[SIGMAV_T15_BRANCH] ;
    const double dummy10=y[8]*y[1]*sigmav[SIGMAV_O17G] ;
    dydt[1]= - dummy7  - dummy5  - dummy8  - dummy1  - dummy9  - dummy4  - dummy2  - dummy10  - dummy3  - dummy0  - dummy6 ;
    dydt[2]= + dummy1  + dummy2  + dummy3  + dummy6 ;
    dydt[3]= - dummy7  + dummy1 ;
    dydt[4]= + dummy7  - dummy5 ;
    dydt[5]= + dummy5  - dummy8  + dummy2 ;
    dydt[6]= + dummy8  - dummy1  - dummy9  + dummy3 ;
    dydt[7]= + dummy9  - dummy4  + dummy6 ;
    dydt[8]= + dummy4  - dummy2  - dummy10 ;
    dydt[9]= + dummy10  - dummy3  - dummy0 ;
    dydt[10]= + dummy0  - dummy6 ;

}


//Jacobian



static void coldCNOjacobian(double ** RESTRICT const J,
                            const double * RESTRICT const N,
                            const double * RESTRICT const sigmav)
{

    const double dummy0=N[XF19]*sigmav[SIGMAV_F19A] ;
    const double dummy1=N[XO16]*sigmav[SIGMAV_T16] ;
    const double dummy2=N[XH1]*sigmav[SIGMAV_T14] ;
    const double dummy3=N[XO17]*sigmav[SIGMAV_O17G] ;
    const double dummy4=N[XH1]*sigmav[SIGMAV_T16] ;
    const double dummy5=N[XO18]*sigmav[SIGMAV_O18G] ;
    const double dummy6=N[XH1]*sigmav[SIGMAV_T17] ;
    const double dummy7=N[XH1]*sigmav[SIGMAV_T13] ;
    const double dummy8=N[XH1]*sigmav[SIGMAV_O18A] ;
    const double dummy9=N[XH1]*sigmav[SIGMAV_O18G] ;
    const double dummy10=N[XN15]*sigmav[SIGMAV_T15] ;
    const double dummy11=N[XN15]*sigmav[SIGMAV_T15_BRANCH] ;
    const double dummy12=N[XH1]*sigmav[SIGMAV_O17G] ;
    const double dummy13=N[XO17]*sigmav[SIGMAV_T17] ;
    const double dummy14=N[XH1]*sigmav[SIGMAV_F19A] ;
    const double dummy15=N[XC13]*sigmav[SIGMAV_T13] ;
    const double dummy16=N[XO18]*sigmav[SIGMAV_O18A] ;
    const double dummy17=N[XH1]*sigmav[SIGMAV_T15_BRANCH] ;
    const double dummy18=N[XH1]*sigmav[SIGMAV_T12] ;
    const double dummy19=N[XN14]*sigmav[SIGMAV_T14] ;
    const double dummy20=N[XC12]*sigmav[SIGMAV_T12] ;
    const double dummy21=N[XH1]*sigmav[SIGMAV_T15] ;
    J[1][1] =   - dummy5  - dummy16  - dummy1  - dummy15  - dummy10  - dummy13  - dummy11  - dummy3  - dummy0  - dummy19  - dummy20;
    J[1][2] = 0.0;
    J[1][3] =   - dummy18;
    J[1][4] =   - dummy7;
    J[1][5] =   - dummy2;
    J[1][6] =   - dummy21  - dummy17;
    J[1][7] =   - dummy4;
    J[1][8] =   - dummy6  - dummy12;
    J[1][9] =   - dummy9  - dummy8;
    J[1][10] =   - dummy14;
    J[2][1] =   + dummy16  + dummy10  + dummy0  + dummy13;
    J[2][2] = 0.0;
    J[2][3] = 0.0;
    J[2][4] = 0.0;
    J[2][5] = 0.0;
    J[2][6] =   + dummy21;
    J[2][7] = 0.0;
    J[2][8] =   + dummy6;
    J[2][9] =   + dummy8;
    J[2][10] =   + dummy14;
    J[3][1] =   - dummy20  + dummy10;
    J[3][2] = 0.0;
    J[3][3] =   - dummy18;
    J[3][4] = 0.0;
    J[3][5] = 0.0;
    J[3][6] =   + dummy21;
    J[3][7] = 0.0;
    J[3][8] = 0.0;
    J[3][9] = 0.0;
    J[3][10] = 0.0;
    J[4][1] =   - dummy15  + dummy20;
    J[4][2] = 0.0;
    J[4][3] =   + dummy18;
    J[4][4] =   - dummy7;
    J[4][5] = 0.0;
    J[4][6] = 0.0;
    J[4][7] = 0.0;
    J[4][8] = 0.0;
    J[4][9] = 0.0;
    J[4][10] = 0.0;
    J[5][1] =   + dummy15  - dummy19  + dummy13;
    J[5][2] = 0.0;
    J[5][3] = 0.0;
    J[5][4] =   + dummy7;
    J[5][5] =   - dummy2;
    J[5][6] = 0.0;
    J[5][7] = 0.0;
    J[5][8] =   + dummy6;
    J[5][9] = 0.0;
    J[5][10] = 0.0;
    J[6][1] =   + dummy16  - dummy10  - dummy11  + dummy19;
    J[6][2] = 0.0;
    J[6][3] = 0.0;
    J[6][4] = 0.0;
    J[6][5] =   + dummy2;
    J[6][6] =   - dummy21  - dummy17;
    J[6][7] = 0.0;
    J[6][8] = 0.0;
    J[6][9] =   + dummy8;
    J[6][10] = 0.0;
    J[7][1] =   - dummy1  + dummy0  + dummy11;
    J[7][2] = 0.0;
    J[7][3] = 0.0;
    J[7][4] = 0.0;
    J[7][5] = 0.0;
    J[7][6] =   + dummy17;
    J[7][7] =   - dummy4;
    J[7][8] = 0.0;
    J[7][9] = 0.0;
    J[7][10] =   + dummy14;
    J[8][1] =   + dummy1  - dummy13  - dummy3;
    J[8][2] = 0.0;
    J[8][3] = 0.0;
    J[8][4] = 0.0;
    J[8][5] = 0.0;
    J[8][6] = 0.0;
    J[8][7] =   + dummy4;
    J[8][8] =   - dummy12  - dummy6;
    J[8][9] = 0.0;
    J[8][10] = 0.0;
    J[9][1] =   - dummy5  - dummy16  + dummy3;
    J[9][2] = 0.0;
    J[9][3] = 0.0;
    J[9][4] = 0.0;
    J[9][5] = 0.0;
    J[9][6] = 0.0;
    J[9][7] = 0.0;
    J[9][8] =   + dummy12;
    J[9][9] =   - dummy9  - dummy8;
    J[9][10] = 0.0;
    J[10][1] =   + dummy5  - dummy0;
    J[10][2] = 0.0;
    J[10][3] = 0.0;
    J[10][4] = 0.0;
    J[10][5] = 0.0;
    J[10][6] = 0.0;
    J[10][7] = 0.0;
    J[10][8] = 0.0;
    J[10][9] =   + dummy9;
    J[10][10] =   - dummy14;
}

#endif

