#include "../binary_c.h"
#if defined NUCSYN && defined NUCSYN_NETWORK_NeNaMgAlnoleak

/* 
 * Network code : NeNaMgAlnoleak
 * Automatically generated by make_reaction_network_code.pl
 */

/*
 * Species / Reactions list:
 *
 * 1 : H1 : -Ne20*H1*SIGMAV_T20 -Ne21*H1*SIGMAV_T21 -Ne22*H1*SIGMAV_T22 -Na23*H1*SIGMAV_T23 -Mg24*H1*SIGMAV_T24 -Mg25*H1*SIGMAV_T25 -Al26*H1*SIGMAV_T26P -Mg26*H1*SIGMAV_T26 -Al27*H1*SIGMAV_T27 -Al27*H1*SIGMAV_T27a 
 * 2 : He4 : +Na23*H1*SIGMAV_T23 +Al27*H1*SIGMAV_T27a 
 * 3 : Ne20 : -Ne20*H1*SIGMAV_T20 +Na23*H1*SIGMAV_T23 
 * 4 : Ne21 : +Ne20*H1*SIGMAV_T20 -Ne21*H1*SIGMAV_T21 
 * 5 : Ne22 : +Ne21*H1*SIGMAV_T21 -Ne22*H1*SIGMAV_T22 
 * 6 : Na23 : +Ne22*H1*SIGMAV_T22 -Na23*H1*SIGMAV_T23 
 * 7 : Mg24 : -Mg24*H1*SIGMAV_T24 +Al27*H1*SIGMAV_T27a 
 * 8 : Mg25 : +Mg24*H1*SIGMAV_T24 -Mg25*H1*SIGMAV_T25 
 * 9 : Mg26 : +Al26*beta*SIGMAV_TBETA26 -Mg26*H1*SIGMAV_T26 
 * 10 : Al26 : +Mg25*H1*SIGMAV_T25 -Al26*beta*SIGMAV_TBETA26 -Al26*H1*SIGMAV_T26P 
 * 11 : Al27 : +Al26*H1*SIGMAV_T26P +Mg26*H1*SIGMAV_T26 -Al27*H1*SIGMAV_T27 -Al27*H1*SIGMAV_T27a 
 * 12 : Si28 : +Al27*H1*SIGMAV_T27 
 *
 */

void NeNaMgAlnoleakjacobian(double ** RESTRICT const J, const double * RESTRICT const N, const double * RESTRICT const sigmav);
void NeNaMgAlnoleakderivatives(const double * RESTRICT const y,double * RESTRICT const dydt,const double * RESTRICT const sigmav,const double * RESTRICT const N);

double nucsyn_burn_NeNaMgAlnoleak (double * RESTRICT const Nin,
                                   const double * RESTRICT const sigmav,
                                   const double h)
{

    /* memory allocation : do this once */
    double err;
    unsigned int i;
    double *JNeNaMgAlnoleak[13];

    for(i=1;i<13;i++)
    {
        JNeNaMgAlnoleak[i]=Malloc(13*sizeof(double));
    }
    
    double yNeNaMgAlnoleak[13],
        y2NeNaMgAlnoleak[13],
        f1NeNaMgAlnoleak[13],
        f2NeNaMgAlnoleak[13],
        f3NeNaMgAlnoleak[13],
        f4NeNaMgAlnoleak[13];
    int indxNeNaMgAlnoleak[13];

    yNeNaMgAlnoleak[1]=Nin[XH1];
    yNeNaMgAlnoleak[2]=Nin[XHe4];
    yNeNaMgAlnoleak[3]=Nin[XNe20];
    yNeNaMgAlnoleak[4]=Nin[XNe21];
    yNeNaMgAlnoleak[5]=Nin[XNe22];
    yNeNaMgAlnoleak[6]=Nin[XNa23];
    yNeNaMgAlnoleak[7]=Nin[XMg24];
    yNeNaMgAlnoleak[8]=Nin[XMg25];
    yNeNaMgAlnoleak[9]=Nin[XMg26];
    yNeNaMgAlnoleak[10]=Nin[XAl26];
    yNeNaMgAlnoleak[11]=Nin[XAl27];
    yNeNaMgAlnoleak[12]=Nin[XSi28];
    err=kaps_rentrop_GSL(h,yNeNaMgAlnoleak,y2NeNaMgAlnoleak,12,JNeNaMgAlnoleak,sigmav,Nin,&NeNaMgAlnoleakjacobian,&NeNaMgAlnoleakderivatives,f1NeNaMgAlnoleak,f2NeNaMgAlnoleak,f3NeNaMgAlnoleak,f4NeNaMgAlnoleak,indxNeNaMgAlnoleak);
    if(err<=1.0)
    {
        Nin[XH1]=yNeNaMgAlnoleak[1];
        Nin[XHe4]=yNeNaMgAlnoleak[2];
        Nin[XNe20]=yNeNaMgAlnoleak[3];
        Nin[XNe21]=yNeNaMgAlnoleak[4];
        Nin[XNe22]=yNeNaMgAlnoleak[5];
        Nin[XNa23]=yNeNaMgAlnoleak[6];
        Nin[XMg24]=yNeNaMgAlnoleak[7];
        Nin[XMg25]=yNeNaMgAlnoleak[8];
        Nin[XMg26]=yNeNaMgAlnoleak[9];
        Nin[XAl26]=yNeNaMgAlnoleak[10];
        Nin[XAl27]=yNeNaMgAlnoleak[11];
        Nin[XSi28]=yNeNaMgAlnoleak[12];
    }  
    for(i=1;i<13;i++)
    {
        Safe_free(JNeNaMgAlnoleak[i]);
    }
    return(err);

}
void NeNaMgAlnoleakderivatives(const double * RESTRICT const y,double * RESTRICT const dydt,const double * RESTRICT const sigmav,const double * RESTRICT const N)
{
    double dummy0=y[10]/sigmav[SIGMAV_TBETA26] ;
    double dummy1=y[11]*y[1]*sigmav[SIGMAV_T27a] ;
    double dummy2=y[4]*y[1]*sigmav[SIGMAV_T21] ;
    double dummy3=y[8]*y[1]*sigmav[SIGMAV_T25] ;
    double dummy4=y[7]*y[1]*sigmav[SIGMAV_T24] ;
    double dummy5=y[11]*y[1]*sigmav[SIGMAV_T27] ;
    double dummy6=y[9]*y[1]*sigmav[SIGMAV_T26] ;
    double dummy7=y[10]*y[1]*sigmav[SIGMAV_T26P] ;
    double dummy8=y[3]*y[1]*sigmav[SIGMAV_T20] ;
    double dummy9=y[5]*y[1]*sigmav[SIGMAV_T22] ;
    double dummy10=y[6]*y[1]*sigmav[SIGMAV_T23] ;
    dydt[1]= - dummy8  - dummy2  - dummy9  - dummy10  - dummy4  - dummy3  - dummy7  - dummy6  - dummy5  - dummy1 ;
    dydt[2]= + dummy10  + dummy1 ;
    dydt[3]= - dummy8  + dummy10 ;
    dydt[4]= + dummy8  - dummy2 ;
    dydt[5]= + dummy2  - dummy9 ;
    dydt[6]= + dummy9  - dummy10 ;
    dydt[7]= - dummy4  + dummy1 ;
    dydt[8]= + dummy4  - dummy3 ;
    dydt[9]= + dummy0  - dummy6 ;
    dydt[10]= + dummy3  - dummy0  - dummy7 ;
    dydt[11]= + dummy7  + dummy6  - dummy5  - dummy1 ;
    dydt[12]= + dummy5 ;

}


//Jacobian



void NeNaMgAlnoleakjacobian(double ** RESTRICT const J,const double * RESTRICT const N, const double * RESTRICT const sigmav)
{

    double dummy0=N[XH1]*sigmav[SIGMAV_T25] ;
    double dummy1=N[XNa23]*sigmav[SIGMAV_T23] ;
    double dummy2=N[XH1]*sigmav[SIGMAV_T26P] ;
    double dummy3=N[XH1]*sigmav[SIGMAV_T20] ;
    double dummy4=N[XAl27]*sigmav[SIGMAV_T27a] ;
    double dummy5=1.0/sigmav[SIGMAV_TBETA26] ;
    double dummy6=N[XMg26]*sigmav[SIGMAV_T26] ;
    double dummy7=N[XH1]*sigmav[SIGMAV_T21] ;
    double dummy8=N[XMg25]*sigmav[SIGMAV_T25] ;
    double dummy9=N[XH1]*sigmav[SIGMAV_T23] ;
    double dummy10=N[XNe21]*sigmav[SIGMAV_T21] ;
    double dummy11=N[XAl27]*sigmav[SIGMAV_T27] ;
    double dummy12=N[XNe20]*sigmav[SIGMAV_T20] ;
    double dummy13=N[XH1]*sigmav[SIGMAV_T27] ;
    double dummy14=N[XNe22]*sigmav[SIGMAV_T22] ;
    double dummy15=N[XH1]*sigmav[SIGMAV_T22] ;
    double dummy16=N[XH1]*sigmav[SIGMAV_T24] ;
    double dummy17=N[XH1]*sigmav[SIGMAV_T26] ;
    double dummy18=N[XMg24]*sigmav[SIGMAV_T24] ;
    double dummy19=N[XAl26]*sigmav[SIGMAV_T26P] ;
    double dummy20=N[XH1]*sigmav[SIGMAV_T27a] ;
    J[1][1] =  - dummy12  - dummy10  - dummy14  - dummy1  - dummy18  - dummy8  - dummy19  - dummy6  - dummy11  - dummy4 ;
    J[2][1] =  + dummy1  + dummy4 ;
    J[3][1] =  - dummy12  + dummy1 ;
    J[4][1] =  + dummy12  - dummy10 ;
    J[5][1] =  + dummy10  - dummy14 ;
    J[6][1] =  + dummy14  - dummy1 ;
    J[7][1] =  - dummy18  + dummy4 ;
    J[8][1] =  + dummy18  - dummy8 ;
    J[9][1] =  - dummy6 ;
    J[10][1] =  + dummy8  - dummy19 ;
    J[11][1] =  + dummy19  + dummy6  - dummy11  - dummy4 ;
    J[12][1] =  + dummy11 ;
    J[1][2] = 0.0;
    J[2][2] = 0.0;
    J[3][2] = 0.0;
    J[4][2] = 0.0;
    J[5][2] = 0.0;
    J[6][2] = 0.0;
    J[7][2] = 0.0;
    J[8][2] = 0.0;
    J[9][2] = 0.0;
    J[10][2] = 0.0;
    J[11][2] = 0.0;
    J[12][2] = 0.0;
    J[1][3] =  - dummy3 ;
    J[2][3] = 0.0;
    J[3][3] =  - dummy3 ;
    J[4][3] =  + dummy3 ;
    J[5][3] = 0.0;
    J[6][3] = 0.0;
    J[7][3] = 0.0;
    J[8][3] = 0.0;
    J[9][3] = 0.0;
    J[10][3] = 0.0;
    J[11][3] = 0.0;
    J[12][3] = 0.0;
    J[1][4] =  - dummy7 ;
    J[2][4] = 0.0;
    J[3][4] = 0.0;
    J[4][4] =  - dummy7 ;
    J[5][4] =  + dummy7 ;
    J[6][4] = 0.0;
    J[7][4] = 0.0;
    J[8][4] = 0.0;
    J[9][4] = 0.0;
    J[10][4] = 0.0;
    J[11][4] = 0.0;
    J[12][4] = 0.0;
    J[1][5] =  - dummy15 ;
    J[2][5] = 0.0;
    J[3][5] = 0.0;
    J[4][5] = 0.0;
    J[5][5] =  - dummy15 ;
    J[6][5] =  + dummy15 ;
    J[7][5] = 0.0;
    J[8][5] = 0.0;
    J[9][5] = 0.0;
    J[10][5] = 0.0;
    J[11][5] = 0.0;
    J[12][5] = 0.0;
    J[1][6] =  - dummy9 ;
    J[2][6] =  + dummy9 ;
    J[3][6] =  + dummy9 ;
    J[4][6] = 0.0;
    J[5][6] = 0.0;
    J[6][6] =  - dummy9 ;
    J[7][6] = 0.0;
    J[8][6] = 0.0;
    J[9][6] = 0.0;
    J[10][6] = 0.0;
    J[11][6] = 0.0;
    J[12][6] = 0.0;
    J[1][7] =  - dummy16 ;
    J[2][7] = 0.0;
    J[3][7] = 0.0;
    J[4][7] = 0.0;
    J[5][7] = 0.0;
    J[6][7] = 0.0;
    J[7][7] =  - dummy16 ;
    J[8][7] =  + dummy16 ;
    J[9][7] = 0.0;
    J[10][7] = 0.0;
    J[11][7] = 0.0;
    J[12][7] = 0.0;
    J[1][8] =  - dummy0 ;
    J[2][8] = 0.0;
    J[3][8] = 0.0;
    J[4][8] = 0.0;
    J[5][8] = 0.0;
    J[6][8] = 0.0;
    J[7][8] = 0.0;
    J[8][8] =  - dummy0 ;
    J[9][8] = 0.0;
    J[10][8] =  + dummy0 ;
    J[11][8] = 0.0;
    J[12][8] = 0.0;
    J[1][9] =  - dummy17 ;
    J[2][9] = 0.0;
    J[3][9] = 0.0;
    J[4][9] = 0.0;
    J[5][9] = 0.0;
    J[6][9] = 0.0;
    J[7][9] = 0.0;
    J[8][9] = 0.0;
    J[9][9] =  - dummy17 ;
    J[10][9] = 0.0;
    J[11][9] =  + dummy17 ;
    J[12][9] = 0.0;
    J[1][10] =  - dummy2 ;
    J[2][10] = 0.0;
    J[3][10] = 0.0;
    J[4][10] = 0.0;
    J[5][10] = 0.0;
    J[6][10] = 0.0;
    J[7][10] = 0.0;
    J[8][10] = 0.0;
    J[9][10] =  + dummy5 ;
    J[10][10] =  - dummy5  - dummy2 ;
    J[11][10] =  + dummy2 ;
    J[12][10] = 0.0;
    J[1][11] =  - dummy13  - dummy20 ;
    J[2][11] =  + dummy20 ;
    J[3][11] = 0.0;
    J[4][11] = 0.0;
    J[5][11] = 0.0;
    J[6][11] = 0.0;
    J[7][11] =  + dummy20 ;
    J[8][11] = 0.0;
    J[9][11] = 0.0;
    J[10][11] = 0.0;
    J[11][11] =  - dummy13  - dummy20 ;
    J[12][11] =  + dummy13 ;
    J[1][12] = 0.0;
    J[2][12] = 0.0;
    J[3][12] = 0.0;
    J[4][12] = 0.0;
    J[5][12] = 0.0;
    J[6][12] = 0.0;
    J[7][12] = 0.0;
    J[8][12] = 0.0;
    J[9][12] = 0.0;
    J[10][12] = 0.0;
    J[11][12] = 0.0;
    J[12][12] = 0.0;

}


#endif
