#include "../binary_c.h"

#if defined NUCSYN && defined NUCSYN_NETWORK_NeNa

/* 
 * Network code : NeNa
 * Automatically generated by make_reaction_network_code.pl
 */

/*
 * Species / Reactions list:
 *
 * 1 : H1 : -Ne20*H1*SIGMAV_T20 -Ne21*H1*SIGMAV_T21 -Ne22*H1*SIGMAV_T22 -Na23*H1*SIGMAV_T23 
 * 2 : He4 : +Na23*H1*SIGMAV_T23 
 * 3 : Ne20 : -Ne20*H1*SIGMAV_T20 +Na23*H1*SIGMAV_T23 
 * 4 : Ne21 : +Ne20*H1*SIGMAV_T20 -Ne21*H1*SIGMAV_T21 
 * 5 : Ne22 : +Ne21*H1*SIGMAV_T21 -Ne22*H1*SIGMAV_T22 
 * 6 : Na23 : +Ne22*H1*SIGMAV_T22 -Na23*H1*SIGMAV_T23 
 *
 */

void NeNajacobian(double ** RESTRICT const J, const double * RESTRICT const N, const double * RESTRICT const sigmav);
void NeNaderivatives(const double * RESTRICT const y,double * RESTRICT const dydt,const double * RESTRICT const sigmav,const double * RESTRICT const N);

double nucsyn_burn_NeNa (double * RESTRICT const Nin,
                         const double * RESTRICT const sigmav,
                         const double h)
{

    /* memory allocation : do this once */
    double err;
    unsigned int i;
    double *JNeNa[7];

    for(i=1;i<7;i++)
    {
        JNeNa[i]=Malloc(7*sizeof(double));
    }
    
    double yNeNa[7],y2NeNa[7],f1NeNa[7],f2NeNa[7],f3NeNa[7],f4NeNa[7];
    int indxNeNa[7];

    yNeNa[1]=Nin[XH1];
    yNeNa[2]=Nin[XHe4];
    yNeNa[3]=Nin[XNe20];
    yNeNa[4]=Nin[XNe21];
    yNeNa[5]=Nin[XNe22];
    yNeNa[6]=Nin[XNa23];
    err=kaps_rentrop_GSL(h,yNeNa,y2NeNa,6,JNeNa,sigmav,Nin,&NeNajacobian,&NeNaderivatives,f1NeNa,f2NeNa,f3NeNa,f4NeNa,indxNeNa);
    if(err<=1.0)
    {
        Nin[XH1]=yNeNa[1];
        Nin[XHe4]=yNeNa[2];
        Nin[XNe20]=yNeNa[3];
        Nin[XNe21]=yNeNa[4];
        Nin[XNe22]=yNeNa[5];
        Nin[XNa23]=yNeNa[6];
    }
    for(i=1;i<7;i++)
    { 
        Safe_free(JNeNa[i]);
    }
    return(err);

}
void NeNaderivatives(const double * RESTRICT const y,double * RESTRICT const dydt,const double * RESTRICT const sigmav,const double * RESTRICT const N)
{
    double dummy0=y[3]*y[1]*sigmav[SIGMAV_T20] ;
    double dummy1=y[5]*y[1]*sigmav[SIGMAV_T22] ;
    double dummy2=y[4]*y[1]*sigmav[SIGMAV_T21] ;
    double dummy3=y[6]*y[1]*sigmav[SIGMAV_T23] ;
    dydt[1]= - dummy0  - dummy2  - dummy1  - dummy3 ;
    dydt[2]= + dummy3 ;
    dydt[3]= - dummy0  + dummy3 ;
    dydt[4]= + dummy0  - dummy2 ;
    dydt[5]= + dummy2  - dummy1 ;
    dydt[6]= + dummy1  - dummy3 ;

}


//Jacobian



void NeNajacobian(double ** RESTRICT const J,const double * RESTRICT const N, const double * RESTRICT const sigmav)
{

    double dummy0=N[XNa23]*sigmav[SIGMAV_T23] ;
    double dummy1=N[XNe21]*sigmav[SIGMAV_T21] ;
    double dummy2=N[XNe20]*sigmav[SIGMAV_T20] ;
    double dummy3=N[XH1]*sigmav[SIGMAV_T20] ;
    double dummy4=N[XNe22]*sigmav[SIGMAV_T22] ;
    double dummy5=N[XH1]*sigmav[SIGMAV_T22] ;
    double dummy6=N[XH1]*sigmav[SIGMAV_T21] ;
    double dummy7=N[XH1]*sigmav[SIGMAV_T23] ;
    J[1][1] =  - dummy2  - dummy1  - dummy4  - dummy0 ;
    J[2][1] =  + dummy0 ;
    J[3][1] =  - dummy2  + dummy0 ;
    J[4][1] =  + dummy2  - dummy1 ;
    J[5][1] =  + dummy1  - dummy4 ;
    J[6][1] =  + dummy4  - dummy0 ;
    J[1][2] = 0.0;
    J[2][2] = 0.0;
    J[3][2] = 0.0;
    J[4][2] = 0.0;
    J[5][2] = 0.0;
    J[6][2] = 0.0;
    J[1][3] =  - dummy3 ;
    J[2][3] = 0.0;
    J[3][3] =  - dummy3 ;
    J[4][3] =  + dummy3 ;
    J[5][3] = 0.0;
    J[6][3] = 0.0;
    J[1][4] =  - dummy6 ;
    J[2][4] = 0.0;
    J[3][4] = 0.0;
    J[4][4] =  - dummy6 ;
    J[5][4] =  + dummy6 ;
    J[6][4] = 0.0;
    J[1][5] =  - dummy5 ;
    J[2][5] = 0.0;
    J[3][5] = 0.0;
    J[4][5] = 0.0;
    J[5][5] =  - dummy5 ;
    J[6][5] =  + dummy5 ;
    J[1][6] =  - dummy7 ;
    J[2][6] =  + dummy7 ;
    J[3][6] =  + dummy7 ;
    J[4][6] = 0.0;
    J[5][6] = 0.0;
    J[6][6] =  - dummy7 ;

}


#endif
