

#include "../binary_c.h"

#ifdef NUCSYN
void nucsyn_build_store_contents(struct store_t * RESTRICT const store)
{

    /*
     * Build store contents for nucleosynthesis
     *
     * See also memory/build_store_contents.c
     *
     * Note: 
     * NOTHING in here can depend on the current stardata.
     * You will NOT have access to stardata here.
     */

    store->mnuc = Calloc(ISOTOPE_ARRAY_SIZE,sizeof(Nuclear_mass));
    store->imnuc=Calloc(ISOTOPE_ARRAY_SIZE,sizeof(Nuclear_mass));
    store->mnuc_amu=Calloc(ISOTOPE_ARRAY_SIZE,sizeof(Nuclear_mass));
    store->imnuc_amu=Calloc(ISOTOPE_ARRAY_SIZE,sizeof(Nuclear_mass));
    store->molweight=Calloc(ISOTOPE_ARRAY_SIZE,sizeof(double));
    store->ZonA=Calloc(ISOTOPE_ARRAY_SIZE,sizeof(double));
    store->atomic_number=Calloc(ISOTOPE_ARRAY_SIZE,sizeof(Atomic_number));
    store->nucleon_number=Calloc(ISOTOPE_ARRAY_SIZE,sizeof(int));

    nucsyn_set_nuc_masses(store->mnuc,
                          store->imnuc,
                          store->mnuc_amu,
                          store->imnuc_amu,
                          store->molweight,
                          store->ZonA,
                          store->atomic_number, 
                          store->nucleon_number);
    
    nucsyn_elemental_abundance(NULL,NULL,NULL,store);
    nucsyn_element_to_atomic_number(store,NULL);
    /* allocate space for sigmav (reaction rates) table */
#ifdef NUCSYN_SIGMAV_PRE_INTERPOLATE
    table_sigmav(store);
#endif//NUCSYN_SIGMAV_PRE_INTERPOLATE
    
    /* 
     * Data tables
     */
    table_1DUP(store);
#if defined NUCSYN && defined NUCSYN_STRIP_AND_MIX
    table_TAMS(store);
#endif
#ifdef NUCSYN_S_PROCESS
    table_s_process(store);
#endif
    #ifdef NUCSYN_NOVAE
    table_novae(store);
#endif

}

#endif  //NUCSYN
