#include "../binary_c.h"
#ifdef NUCSYN

/*
 * Short functions to convert and multiply mass fraction arrays
 */


void Xmult(Abundance * RESTRICT X,
           const double f)
{
    /* multiply an abundance array X by f */
    Isotope i;
    Isotope_loop(i)
    {
        prefetch(X+i+Isotope_loop_sign);
        X[i] *= f;
    }
}


/*
 * Functions to convect from mass fraction (X) to number density (N) and vice
 * versa : requires the nuclear masses (mnuc, must be set!) and the density.
 * The number of species in the various arrays is passed in, though is usually
 * ISOTOPE_ARRAY_SIZE
 */

void X_to_N(const Nuclear_mass * RESTRICT imnuc, /* NB inuc=1.0/mnuc */
            const double  dens,
            Number_density * RESTRICT N,
            const Abundance * RESTRICT X,
            const Isotope num_species)
{
    Isotope i;
    for(i=0;i<num_species;i++)
    {
        prefetch(imnuc+i);
        prefetch(X+i);
        N[i]=imnuc[i]*X[i]*dens;
    }
}

void N_to_X(const Nuclear_mass * RESTRICT mnuc,
            const double dens,
            const Number_density * RESTRICT N,
            Abundance * RESTRICT X,
            const Isotope num_species)
{
    const double idens=1.0/dens;
    Isotope i;
    for(i=0;i<num_species;i++)
    {
        prefetch(mnuc+i);
        prefetch(N+i);
        X[i]=mnuc[i]*N[i]*idens;
    } 
}
#endif//NUCSYN
