#!/bin/bash

# make data objects for nucsyn with binary_c

: ${CC:="gcc"}
: ${OBJCOPY_OPTS:="-I binary -B i386:x86-64 -O elf64-x86-64"}

# large s-process table

HFILE=nucsyn_extended_s_process.h
TMPFILE=nucsyn_extended_s_process.dat
OBJFILE=nucsyn_extended_s_process.o

if [ $HFILE -nt $OBJFILE ] ; then

    $CC -fPIC -O0 ../../double2bin.c -o ./double2bin
    
    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \* |grep . | ./double2bin > $TMPFILE
    
    
    objcopy $OBJCOPY_OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE
    
    rm $TMPFILE
    rm ./double2bin

fi

echo $OBJFILE


# novae

HFILE=nucsyn_novae_JH98_CO.h
TMPFILE=nucsyn_novae_JH98_CO.dat
OBJFILE=nucsyn_novae_JH98_CO.o

if [ $HFILE -nt $OBJFILE ] ; then
    
    $CC -fPIC -O0 ../../double2bin.c -o ./double2bin
        
    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \* |grep . | ./double2bin > $TMPFILE
    
    objcopy $OBJCOPY_OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE
    
    rm $TMPFILE
    rm ./double2bin

fi

echo $OBJFILE

HFILE=nucsyn_novae_JH98_ONe.h
TMPFILE=nucsyn_novae_JH98_ONe.dat
OBJFILE=nucsyn_novae_JH98_ONe.o

if [ $HFILE -nt $OBJFILE ] ; then

    $CC -fPIC -O0 ../../double2bin.c -o ./double2bin
    
    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \* |grep . | ./double2bin > $TMPFILE
    
    objcopy $OBJCOPY_OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE
    
    rm $TMPFILE
    rm ./double2bin

fi

echo $OBJFILE






