#pragma once
#ifndef NOVAE_PROTOTYPES_H
#define NOVAE_PROTOTYPES_H


Constant_function double nova_recurrence_time(const double mdot,
                                              const double mwd);

double Pure_function nova_explosion_layer_mass(struct stardata_t * RESTRICT const stardata,
                                               struct star_t * const accretor);


double Pure_function nova_retention_fraction(struct stardata_t * const stardata,
                                             struct star_t * const accretor,
                                             struct star_t MAYBE_UNUSED * const donor,
                                             const double accretion_rate,
                                             const double steady_burn_rate);

double Pure_function dwarf_nova_critical_mass_transfer_rate(struct stardata_t * const stardata,
                                                            struct star_t * const donor,
                                                            struct star_t * const accretor);

Event_handler_function nova_event_handler(void * const eventp,
                                          struct stardata_t * const stardata,
                                          void * data);

Event_handler_function nova_erase_event_handler(void * eventp,
                                                     struct stardata_t * stardata,
                                                void * data);

void nova_angular_momentum_changes(
    struct stardata_t * const stardata,
    struct star_t * const exploder,
    const double dm,
    double * const dJstar,
    double * const dJorb
    );

#endif // NOVAE_PROTOTYPES_H

