
#include "../binary_c.h"

Constant_function double nova_recurrence_time(const double mdot,
                                              const double mwd)
{
    /*
     * Recurrence time for novae of mass mwd (solar masses) accreting at
     * a rate mdot (Msun/year).  See Livio and Truran 1992.
     *
     * Result is in years.
     */
    double t =
        8.66e4 * (1e-9/mdot) * 
        (1.54 * pow(mwd,-7.0/3.0) 
         - 2.0 / mwd 
         +0.65 * cbrt(mwd));
    return t;
}
