#include "../binary_c.h"

void * Returns_nonnull Nonnull_all_arguments Hot_function strided_memcpy(void * dst,
                                                                         void * src,
                                                                         const size_t length,
                                                                         const size_t blocksize)
{
    /*
     * Copy memory from src to dst of size length in 
     * blocksize strides.
     *
     * If the block hasn't changed, don't  copy it.
     *
     * The idea is that reading of RAM is faster than 
     * writing of RAM, so if the number of changes is 
     * small, it should be faster to not copy most
     * of the memory.
     *
     * Neither dst nor src should even be NULL.
     */
    const void * const start_dest = dst;
    const void * const end_dest = dst + length;
    
    while(dst < end_dest)
    {
        const size_t thisblocksize = Min(end_dest - dst,
                                         blocksize);
        if(thisblocksize &&
           !Memory_equal(src,
                         dst,
                         thisblocksize))
        {
            /*
             * Differ : copy.
             * Use memcpy for this: I tried a loop but it was slower.
             */
            memcpy(dst,src,thisblocksize);
        }
        src += thisblocksize;
        dst += thisblocksize;
    }
    return (void *)start_dest;
}
