#pragma once
#ifndef MEMORY_PROTOTYPES_H
#define MEMORY_PROTOTYPES_H

void free_memory(struct stardata_t ** RESTRICT const sp,
		 const Boolean free_preferences,
                 const Boolean free_stardata,
                 const Boolean free_store,
                 const Boolean free_raw_buffer);
void free_aux_memory(void);
void * aligned_memcpy(void * dest,
                      void * src,
                      size_t size);
void main_allocations(struct stardata_t ** const stardata,
                      struct stardata_t *** const previous_stardatas,
                      struct preferences_t ** const preferences,
                      struct store_t ** const store);
void initialize_pointers(struct stardata_t * const stardata,
                         struct preferences_t * const preferences,
                         struct store_t * const store);

void build_store_contents(struct store_t * RESTRICT const store);
void build_tmpstore_contents(struct tmpstore_t * RESTRICT const tmpstore);
void free_store_contents(struct store_t * RESTRICT const store);
void free_tmpstore(struct tmpstore_t * RESTRICT const tmpstore,
                   const Boolean free_raw_buffer);
void *check_aligned_memcpy_heap_source(void * dest,
                                       const void * src,
                                       size_t n);
void *check_aligned_memcpy_stack_source(void * dest,
                                        const void * src,
                                        size_t n);

#ifdef ALIGNSIZE
No_return
#endif
void aligned_memcpy_fail(const void * dest,                                 
                         const void * src,                            
                         const size_t n);

void * rob_memcpy(void * dest,                                 
                  const void * src,                            
                  const size_t n);

#ifdef USE_SKYWIND_FAST_MEMCPY
void* memcpy_fast(void *destination, const void *source, size_t size);
#endif

#ifdef USE_APEX_MEMMOVE
#include "apex_memmove.h"
#endif

#ifdef USE_MEMCPY_DDR4 
void *fastMemcpy_ddr4(void *pvDest, void *pvSrc, size_t nBytes);
#endif

#ifdef CODESTATS
void * Returns_nonnull Nonnull_all_arguments codestats_memcpy(void * dest,
                                                              const void * src,
                                                              size_t n,
                                                              char *const file,
                                                              const long int line);
#endif//CODESTATS

void free_previous_stardatas(struct stardata_t * RESTRICT const stardata);
void free_stardata_stack(struct stardata_t * RESTRICT const stardata);

struct stardata_t * Returns_nonnull Nonnull_all_arguments copy_stardata(
    const struct stardata_t  *  RESTRICT Aligned const from,
    struct stardata_t  * RESTRICT Aligned  const to,
    const unsigned int copy_previous 
    );

float Pure_function diff_struct_pc(void * const a,
                                   void * const b,
                                   const size_t len);
void * Returns_nonnull Nonnull_all_arguments strided_memcpy(void * dst,
                                                            void * src,
                                                            const size_t length,
                                                            const size_t blocksize);

#endif // MEMORY_PROTOTYPES_H
