
#include "../binary_c.h"

void main_allocations(struct stardata_t ** const new_stardata,
                      struct stardata_t *** const previous_stardatas,
                      struct preferences_t ** const preferences,
                      struct store_t ** const store)
{
    /*
     * Allocate memory for new_stardata, previous_stardata,
     * preferences and store. 
     *
     * You should pass in pointers to pointers which are either
     * NULL : in which case they are assigned memory appropriately,
     * or
     * non-NULL : in which case they are used (and we assume they
     *            were assigned by a previous call). In the case
     *            of new_stardata, previous_stardata and preferences,
     *            the structures are zeroed. (The store is not.)
     *
     * build_store_contents is called to fill the store, should
     * it be empty.
     *
     * A few preferences are set. Perhaps this part should
     * be moved elsewhere.
     */
        
    /*
     * The stardata structure contains all of the stuff
     * to describe the physics of
     * the binary star system - see binary_c_structures.h for details.
     */
    if(new_stardata!=NULL && *new_stardata == NULL)
    {
        *new_stardata = New_clear_stardata;
    }
    else
    {
        Clear_stardata(*new_stardata);
    }

    /*
     * Set up the permanent store
     */ 
    if(store!=NULL && *store==NULL)
    {
        *store = Calloc(sizeof(struct store_t),1);
    }
    else if(store==NULL && *store==NULL)
    {
        (*new_stardata)->store = Calloc(sizeof(struct store_t),1);
        *store = (*new_stardata)->store;
    }
    
        
    /*
     * Set up the preferences
     */
    if(preferences!=NULL && *preferences==NULL)
    {
        *preferences = Calloc(sizeof(struct preferences_t),1);
        (*new_stardata)->preferences = *preferences;
    }
    else if(preferences==NULL)
    {
        (*new_stardata)->preferences = Calloc(sizeof(struct preferences_t),1);
    }
    else
    {
        memset(*preferences,0,sizeof(struct preferences_t));
    }

    /*
     * The tmpstore should always be reset
     */
    free_tmpstore((*new_stardata)->tmpstore,TRUE);
    (*new_stardata)->tmpstore = Calloc(sizeof(struct tmpstore_t),1);

    /*
     * Set up pointers to various sub-structures and join
     * new_stardata and preferencs
     */
    initialize_pointers(*new_stardata,(*new_stardata)->preferences,*store);

    /*
     * Build the data stores
     */
    build_tmpstore_contents((*new_stardata)->tmpstore);
    build_store_contents(*store);

    /*
     * Set up command line argument array
     */
    parse_arguments(0,0,NULL,*new_stardata);

    if(previous_stardatas != NULL)
    {
        /*
         * If previous_stardatas is non-null and contains data, use it.
         * Assume number of stardatas requires is the same.
         */
        (*new_stardata)->previous_stardatas = *previous_stardatas;
        (*new_stardata)->n_previous_stardatas = (*previous_stardatas[0])->n_previous_stardatas;
    }
    else
    {
        /*
         * We must have at least one previous_stardata,
         * so allocate that, and allow the rest to be 
         * allocated on the fly.
         */
        (*new_stardata)->previous_stardatas = Malloc(sizeof(struct stardata_t *));
        (*new_stardata)->previous_stardatas[0] = New_clear_stardata;
        (*new_stardata)->n_previous_stardatas = 1;
    }
    (*new_stardata)->previous_stardata = (*new_stardata)->previous_stardatas[0];

    /*
     * Set preferences and store in previous_stardata : 
     * this is for debugging (diff_stardata) output
     */

    (*new_stardata)->previous_stardata->preferences = (*new_stardata)->preferences;
    (*new_stardata)->previous_stardata->store = (*new_stardata)->store;
    (*new_stardata)->previous_stardata->tmpstore = (*new_stardata)->tmpstore;

    /*
     * The struct containing runtime preferences :
     * set some to defaults.
     */
    (*new_stardata)->preferences->repeat = 1;
#ifdef BATCHMODE
    (*new_stardata)->preferences->batchmode = BATCHMODE_OFF;
    (*new_stardata)->preferences->batch_submode = BATCH_SUBMODE_NORMAL;
#endif
    
#ifdef BUFFERED_STACK
    /* default output to stdout */
    (*new_stardata)->preferences->output_type = OUTPUT_TO_STREAM;
    (*new_stardata)->preferences->output_stream = stdout;
    (*new_stardata)->preferences->stream_buffer = NULL;
    (*new_stardata)->preferences->stream_buffer_stacksize = 0;
#endif
    set_default_preferences((*new_stardata)->preferences);

    if(1)
    {
        struct stardata_t * stardata = *new_stardata;
        Dprint("pointers initialized : new_stardata=%p preferences=%p previous_stardatas=%p stardata->preferences=%p stardata=%p stardata->preferences=%p\n",
               stardata, 
               stardata->preferences,
               stardata->previous_stardatas,
               stardata->preferences, 
               stardata, 
               stardata->preferences);
    }



    fool_cpu(); 
}
