#include "../binary_c.h"

#define Tmp_free(P) Safe_free(tmpstore->P)

void free_tmpstore(struct tmpstore_t * RESTRICT const tmpstore,
                   const Boolean free_raw_buffer)
{
    /*
     * Free the contents of the temporary data store (tmpstore) 
     * if it's non-null, and free the tmpstore itself
     */
    if(tmpstore)
    {
        free_difflogstack(tmpstore->logstack);
#ifdef KICK_CDF_TABLE
        Delete_data_table(tmpstore->cdf_table);
#endif

        Tmp_free(unresolved_magnitudes);
        {
            Star_number k;
            Starloop(k)
            {
                Tmp_free(stellar_magnitudes[k]);
            }
        }

        if(free_raw_buffer == TRUE)
        {
            Tmp_free(error_buffer);
            Tmp_free(raw_buffer);
        }
        Tmp_free(stellar_structure_newstar);
        Tmp_free(stellar_evolution_newstar);
        Tmp_free(buffer_string);
        tmpstore->raw_buffer_size=0;
#ifdef BATCHMODE
        Tmp_free(batchstring);
        Tmp_free(batchstring2);
        Tmp_free(batchargs);
#endif
        
#ifdef NUCSYN
#ifdef NUCSYN_STELLAR_POPULATIONS_ENSEMBLE
        Tmp_free(ensemble_type);
#endif
        Tmp_free(Xwind_gain);
#ifdef NUCSYN_NOVAE
        Tmp_free(Xnovae);
#endif
        {
            Star_number k;
            Starloop(k)
            {
                Tmp_free(nXacc[k]);
                Tmp_free(nXenv[k]);
            }
        }

#endif//NUCSYN
#ifdef LAMBDA_CE_WANG_2016
        //Tmp_free(comenv_lambda_data);
        Delete_data_table(tmpstore->comenv_lambda_table);
#endif
#ifdef WTTS_LOG
        {
            unsigned int i;
            for(i=0;i<=1;i++)
            {
                Safe_fclose(tmpstore->fp_star[i]);
            }
            Safe_fclose(tmpstore->fp_sys);
        }
#endif // WTTS_LOG

        Delete_data_table(tmpstore->Peters_grav_wave_merger_time_table);
        

        if(tmpstore->rinterpolate_data != NULL)
        {
#ifdef CHECK_RINTERPOLATE
            printf("FREE %p\n",tmpstore->rinterpolate_data);
#endif
            rinterpolate_free_data(tmpstore->rinterpolate_data);
            Safe_free(tmpstore->rinterpolate_data);
        }


        {
            /*
             * Free command line arguments table
             */
            int i;
            for(i=0; i<tmpstore->arg_count; i++)
            {
                if(tmpstore->cmd_line_args[i].nargpairs > 0)
                {
                    int j;
                    for(j=0; j<tmpstore->cmd_line_args[i].nargpairs; j++)
                    {
                        Tmp_free(cmd_line_args[i].argpairs[j].string);
                    }
                }
                Tmp_free(cmd_line_args[i].argpairs);
                Tmp_free(cmd_line_args[i].pairs);
            }
            Tmp_free(cmd_line_args);
        }


#ifdef ALPHA_ARGS
        {
            unsigned int i;
            for(i=0;i<ALPHA_ARGS_SIZE;i++)
            {
                Safe_free(tmpstore->cmd_line_args_alpha[i]);
            }
            Safe_free(tmpstore->cmd_line_args_alpha);
            Safe_free(tmpstore->cmd_line_args_alpha_count);
        }
#endif//ALPHA_ARGS

        /*
         * Free the memory in tmpstore, but don't set it
         * to NULL
         */
        Unsafe_free(tmpstore);
    }
}
