#include "../binary_c.h"

#define Store_free(P) Safe_free(store->P);

void free_store_contents(struct store_t * RESTRICT const store)
{
    /*
     * Free the content in the store.
     * See also build_store_contents.c
     *
     * Note: 
     * NOTHING in here can depend on the current stardata.
     * You will NOT have access to stardata here.
     */
    
    if(store)
    {
#ifdef NUCSYN
        nucsyn_free_store_contents(store);
#endif

        int kt;
        for(kt=0;kt<COLLISION_MATRIX_SIZE;kt++)
        {
            Store_free(collision_matrix[kt]);
        }

        Delete_data_table(store->jaschek_jaschek_dwarf);
        Delete_data_table(store->jaschek_jaschek_giant);
        Delete_data_table(store->jaschek_jaschek_supergiant);
        
#ifdef USE_2012_MAIN_SEQUENCE_LIFETIMES_TABLE
        Delete_data_table(store->massive_MS_lifetimes);
#endif
#ifdef MAIN_SEQUENCE_STRIP
        Delete_data_table(store->MS_strip);
#endif
#ifdef STELLAR_COLOURS
        Delete_data_table(store->Eldridge2012_colours);
        binary_magnitudes(NULL,
                       store,
                       0,
                       NULL,NULL,NULL,NULL,
                       NULL,NULL,NULL,NULL,
                       NULL,NULL,NULL,NULL);
                       
#endif
#ifdef LAMBDA_CE_WANG_2016
        Store_free(tableh1);
        Store_free(tableh2);
        Store_free(tableh3);
        Store_free(tableb1);
        Store_free(tableb2);
        Store_free(tableb3);
        Store_free(tableg1);
        Store_free(tableg2);
        Store_free(tableg3);
        Store_free(comenv_maxR_table->data);
        Delete_data_table(store->comenv_maxR_table);
#endif
#ifdef USE_BSE_MS_LR
        Delete_data_table(store->BSE_MS_LR);
#endif
#ifdef COMENV_POLYTROPES
        Delete_data_table(store->comenv_polytrope_2d);
        Store_free(comenv_polytrope_3d);
        Delete_data_table(store->comenv_polytrope_rsms);
#endif
        Delete_data_table(store->Karakas_ncal);
#ifdef OPACITY_ALGORITHMS
#  ifdef OPACITY_ENABLE_ALGORITHM_FERGUSON_OPAL
        Store_free(opacity_ferguson_opal);
#  endif
#  ifdef OPACITY_ENABLE_ALGORITHM_STARS
        Store_free(opacity_STARS);
#  endif
#endif
        Store_free(miller_bertolami);
        Store_free(miller_bertolami_coeffs_L);
        Store_free(miller_bertolami_coeffs_R);
        Delete_data_table(store->Karakas2002_lumfunc);
        Delete_data_table(store->Karakas2002_radius);
#ifdef BINT
        BINT_free_store(store);
#endif
    }
}
