#include "binary_c.h"

/*
 * Function to free memory on exit from the binary_c program
 *
 * If free_preferences is TRUE, the preferences struct is freed.
 * If free_stardata is TRUE, the stardata struct is freed.
 * If free_store is TRUE, the store struct is freed.
 *
 * Enable FMDebug to debug this function : Dprint might not 
 * work because the structures it uses are successively freed
 * during this function.
 */

//#define FMDebug(...) fprintf(stderr,__VA_ARGS__);
#define FMDebug(...)

void free_memory(struct stardata_t ** RESTRICT const sp,
		 const Boolean free_preferences,
                 const Boolean free_stardata,
                 const Boolean free_store,
                 const Boolean free_raw_buffer)
    
{
    struct stardata_t * stardata = (sp==NULL) ? NULL : *sp;
    
    FMDebug(
        "Freeing memory, sp = %p, *sp = %p, stardata = %p, free_preferences=%d, free_stardata=%d, free_store=%d\n",
        sp,
        (sp!=NULL ? *sp : NULL),
        stardata,
        free_preferences,
        free_stardata,
        free_store);

    /*
     * What to do if stardata is NULL?
     */
    if(sp==NULL || stardata==NULL) return;

#ifdef MEMMAP
    FMDebug("Call munmap\n");
    munmap(stardata->biglog,BIGLOG_SIZE);
#endif /* MEMMAP */
#ifdef FILE_LOG
    FMDebug("Free file_log_prevstring = %p\n",
            (*sp)->common.file_log_prevstring);
    Safe_free((*sp)->common.file_log_prevstring);
#endif
#ifdef DISCS
    FMDebug("Discs\n");
    disc_mem_cleanup(stardata);
#endif
    FMDebug("Diff stats\n");
#ifdef NUCSYN
    FMDebug("Nucsyn\n");
#endif // NUCSYN
        
    FMDebug("interpolate\n");
    
#ifdef FILE_LOG
    FMDebug("log files\n");
    close_log_files(&(stardata->model.log_fp),stardata);
#endif // FILE_LOG
#ifdef BINARY_C_API
    binary_c_API_close_logfile(stardata);
#endif // BINARY_C_API
    
    FMDebug("aux\n");
    free_aux_memory();
    
#if defined BACKTRACE && defined USE_BACKTRACE_CACHE
    backtrace_free_cache_memory();
#endif

    if(free_preferences==TRUE)
    {
        FMDebug("preferences %p\n",stardata->preferences);
        Safe_free(stardata->preferences);
    }

    FMDebug("tmpstore %p\n",stardata->tmpstore);
    free_tmpstore(stardata->tmpstore,
                  free_raw_buffer);
    
    if(free_store == TRUE)
    {
        FMDebug("Free store contents %p\n",stardata->store);
        free_store_contents(stardata->store);

        FMDebug("Free store %p\n",stardata->store);
        Safe_free(stardata->store);
    }

    if(free_stardata == TRUE)
    {
        FMDebug("previous stardatas\n");
        if(stardata!=NULL)
        {
            free_previous_stardatas(stardata);
            free_stardata_stack(stardata);
        }
        FMDebug("STARDATA %p\n",stardata);
        Safe_free(*sp);
    }

    FMDebug("free_memory returning, stardara=%p, sp=%p ",stardata,sp);
#ifdef COUNT_MEMORY
    FMDebug("memuse=%p",memuse);
#endif
    FMDebug("\n");

}

