#include "../binary_c.h"

#include "../binary_c_collision_matrix.h"   

void build_store_contents(struct store_t * RESTRICT const store)
{
    /*
     * Build data content in the store.
     * See also free_store_contents.c
     *
     * Note that data in the core is true *constant* data:
     * it must not change as a function of any parameters
     * (e.g. metallicity). 
     * 
     * Data that depends on parameters of the system 
     * should be stored in the stardata->common struct,
     * is initialized at the start of evolution (see init_common).
     *
     * Note: 
     * NOTHING in here can depend on the current stardata.
     * You will NOT have access to stardata here.
     */

    if(store->built==FALSE)
    {
        store->built = TRUE;
        int i; 
#ifdef NUCSYN 
        nucsyn_build_store_contents(store);
#endif // NUCSYN

        /* 
         * Set up collision stellar (k) type matrix
         */
        Stellar_type const_collision_matrix[Align(COLLISION_MATRIX_SIZE)][Align(COLLISION_MATRIX_SIZE)] Aligned  = COLLISION_MATRIX;

#ifndef ALLOW_HeWD_SUPERNOVAE
        /*
         * Force HeWD-HeWD mergers to become HeMS stars 
         * (i.e. reignite but do not disrupt)
         */
        const_collision_matrix[HeWD][HeWD]=HeMS;
#endif // ALLOW_HeWD_SUPERNOVAE
        size_t x = COLLISION_MATRIX_SIZE*sizeof(Stellar_type);
        for(i=0;i<COLLISION_MATRIX_SIZE;i++)
        {
            store->collision_matrix[i] = Malloc(x);
            memcpy(store->collision_matrix[i],
                   const_collision_matrix[i],
                   x);
        }

#ifdef FILE_LOG
        static const char *const_label[STRING_LENGTH]=LOG_LABELS;
        for(i=0;i<NLOG_LABELS;i++)
        {
            store->label[i]=const_label[i];
        }
#endif // FILE_LOG
#ifdef STELLAR_COLOURS
        binary_magnitudes(NULL,
                       store,
                       0,
                       NULL,NULL,NULL,NULL,
                       NULL,NULL,NULL,NULL,
                       NULL,NULL,NULL,NULL);
        table_Eldridge2012_magnitudes(store);
#endif // STELLAR_COLOURS
        table_spectral_types(store);
#ifdef USE_2012_MAIN_SEQUENCE_LIFETIMES_TABLE
        table_massive_MS_lifetimes(store);
#endif // USE_2012_MAIN_SEQUENCE_LIFETIMES_TABLE
        table_comenv(store);
        table_BSE(store);
        table_Karakas_ncal(store);

#ifdef COMENV_POLYTROPES
        table_comenv_polytropes(store);
#endif // COMENV_POLYTROPES
#ifdef OPACITY_ALGORITHMS
#ifdef OPACITY_ENABLE_ALGORITHM_PACZYNSKI
        table_opacity_paczynski(store);
#endif // OPACITY_ENABLE_ALGORITHM_PACZYNSKI
#ifdef OPACITY_ENABLE_ALGORITHM_STARS
        table_opacity_STARS(store);
#endif // OPACITY_ENABLE_ALGORITHM_STARS
#ifdef OPACITY_ENABLE_ALGORITHM_FERGUSON_OPAL
        table_opacity_ferguson_opal(store);
#endif // OPACITY_ENABLE_ALGORITHM_FERGUSON_OPAL
#endif // OPACITY_ALGORITHMS
        table_miller_bertolami(store);
        table_Karakas2002_lumfunc(store);
        table_Karakas2002_radius(store);
        
        store->built = TRUE;
        store->debug_stopping = 0;
    }
}
