#include "../binary_c.h"
#ifdef NANCHECKS
#include <stdint.h>
//9.05
/*
 * Code to check an array for NaNs: if we find one then
 * exit binary_c and give an error
 *
 * x points to the array, which is of size s
 *
 * nancheck_oops is called if a nan is found
 */
static void nancheck_oops(struct stardata_t * stardata,
                          const char * RESTRICT label,
                          const double * RESTRICT x,
                          const unsigned int i,
                          const unsigned int s);

#define OOPS nancheck_oops(stardata,label,x,i,s)

#ifndef USE_NATIVE_ISNAN
int my_isnan(double val)
{
    /*
     * This may be faster than libm's isnan()
     * but may not work.
     */

    /* this works only on 64-bit architectures */
//    union { double f; uint64_t x; } u = { val };
//    return (u.x << 1) > 0x7ff0000000000000u;

    /* this should always work */
    return (val!=val);
}
#endif


void _nancheck(struct stardata_t * RESTRICT const stardata,
               const char * RESTRICT const label,
               const double * RESTRICT const x,
               const unsigned int s)
{
    /* check pointer is not null */
    if(unlikely(x==NULL)) return ;

    unsigned int i = s;
    while(i)
    {
        i--;
        if(unlikely(_Nanchecker(x[i])!=0))
        {
            OOPS;
        }
    }
}


static void nancheck_oops(struct stardata_t * stardata,
                          const char * RESTRICT label, 
                          const double * RESTRICT x,
                          const unsigned int i,
                          const unsigned int s
    )
                          
{
    // oops
    printf("NaN detected in %s at %d (max %d)\n",label,i,s-1);
    fflush(stdout);
    fprintf(stderr,"NaN detected in %s at %d (max %d)\n",label,i,s-1);
    fflush(stderr);
#ifdef BACKTRACE
    Backtrace;
#endif
    fflush(NULL);
    // segfault for gdb
    //kill(0,SIGSEGV);
    Exit_binary_c(BINARY_C_EXIT_NAN,"NaN detected in %s at %d (max %d)",label,i,s-1);
    free(NULL);
}
#endif
