#include "../binary_c.h"
#include <gsl/gsl_linalg.h>

void kaps_rentrop_LU_decomp(double ** RESTRICT a,
                         const int n2,
                         gsl_matrix * m,
                         gsl_permutation * p
    )
{
#ifdef USE_GSL
    /*
     * Perform LU decomposition using GSL
     */
    unsigned int i,j;
    for(i=1;i<n2;i++)
    {
        double *aa = a[i]; 
        for(j=1;j<n2;j++)
        {
            gsl_matrix_set(m,i-1,j-1,aa[j]);
        }
    }
    
    int ss;
    gsl_linalg_LU_decomp(m, p, &ss);
    for(i=1;i<n2;i++)
    {
        double *aa = a[i]; 
        for(j=1;j<n2;j++)
        {
            aa[j] = gsl_matrix_get(m,i-1,j-1);
        }
    }
#endif
}
