#include "../binary_c.h"
#include <gsl/gsl_linalg.h>

void kaps_rentrop_LU_backsub(double  ** RESTRICT a,
                             double  * RESTRICT b,
                             const int n2,
                             gsl_matrix * m,
                             gsl_permutation * p

    )
{

#ifdef USE_GSL
    /*
     * LU substitution using GSL
     */
    unsigned int i;
    gsl_vector * gsl_b = New_GSL_vector(n2-1);
    gsl_vector * gsl_x = New_GSL_vector(n2-1);
    for(i=0;i<n2-1;i++)
    {
        gsl_vector_set(gsl_b,i,b[i+1]);
    }
    gsl_linalg_LU_solve(m,
                        p,
                        gsl_b,
                        gsl_x);
    for(i=1;i<n2;i++)
    {
        b[i] = gsl_vector_get(gsl_x,i-1); 
    }
    Safe_free_GSL_vector(gsl_b);
    Safe_free_GSL_vector(gsl_x);
#endif // USE_GSL

}
