#include "../binary_c.h"

double Pure_function bin_data(const double x,
                              const double bin_width)
{
    /*
     * bin data : copysign returns the sign of x
     * (standard math library func)
     */
    double sign = copysign(1.0,x);

    /*
     * Bin to the nearest bin_width
     */
    return (
        (
            ((int)(x/bin_width)) + 0.5*sign
            )*bin_width
        );
}
