#include "../binary_c.h"

void show_derivatives(struct stardata_t * RESTRICT const stardata)
{
    /*
     * Show all (non-zero) derivatives
     */
    static const char * c[100] = STELLAR_DERIVATIVE_STRINGS;
    static const char * corb[100] = ORBIT_AND_SYSTEM_DERIVATIVE_STRINGS;
    struct stardata_t * prev = stardata->previous_stardata;
    int d;
    Star_number n;
    Boolean shown_timestep = FALSE;
    
    Printf("************************************************************\n");
    Printf("Stellar Derivatives at t=%30.20e (dtm=%g)\n",
           stardata->model.time,
           stardata->model.dtm);

#define _show_star(STAR,COLOUR,HEADER)                                  \
    Printf("%s%s %d type %2d M=%10g Mc=%10g Menv=%10g L=%10g R=%10g RL=%10g J=%10g omega=%10g I=%10g %s\n", \
           (COLOUR),                                                    \
           (HEADER),                                                    \
           (STAR)->starnum,                                             \
           (STAR)->stellar_type,                                        \
           (STAR)->mass,                                                \
           (STAR)->core_mass,                                           \
           (STAR)->mass - (STAR)->core_mass,                            \
           (STAR)->luminosity,                                          \
           (STAR)->radius,                                              \
           (STAR)->roche_radius,                                        \
           (STAR)->angular_momentum,                                    \
           (STAR)->omega,                                               \
           moment_of_inertia((STAR),((STAR)->radius)),                  \
           COLOUR_RESET                                                 \
        )

    Starloop(n)
    {
        SETstar(n);
        _show_star(star,"","Star");

        if(prev != NULL)
        {
            _show_star(&prev->star[star->starnum],YELLOW,"Prev");
        }
    }

    Boolean dolog = FALSE;
    for(d=0;d<NUMBER_OF_STELLAR_DERIVATIVES;d++)
    {
        Boolean dostar = FALSE;
        Starloop(n)
        {
            if(Is_really_not_zero(stardata->star[n].derivative[d])) 
            {
                dostar = TRUE;
            }
        }
        if(dostar == TRUE)
        { 
            dolog = TRUE;
            if(shown_timestep == FALSE)
            {
                Printf("Timesteps dt = %10g, dtm = %10g\n",
                       stardata->model.dt,
                       stardata->model.dtm);
                Starloop(n)
                {
                    struct star_t * star = & stardata->star[n];
                    Printf("Star %d : Net dM/dt = %10g, dJ/dt = %10g\n",
                           n,
                           Mdot_net(star),
                           Jdot_net(star)
                        );
                }
                shown_timestep = TRUE;
            }
            Printf("DERIV % 3d %30s : ",d,c[d]);
            Starloop(n)
            {
                Printf("% 20g : ",
                       stardata->star[n].derivative[d]);
            }
            if(prev != NULL)
            {
                Printf("%s",YELLOW);
                Starloop(n)
                {
                    Printf("% 20g %% : ",
                           Percent_diff(stardata->star[n].derivative[d],
                                  prev->star[n].derivative[d]));
                }
                Printf("%s",COLOUR_RESET);
            }
            Printf("\n");
        }
    }
    Starloop(n)
    {
        struct star_t * star = & stardata->star[n];
        Printf("JDOT gain %10g loss %10g net %10g\n",Jdot_gain(star),Jdot_loss(star),Jdot_net(star));
    }
    
#define _show_system(STARDATA,COLOUR,HEADER)                            \
    Printf("%s%s at t=%10g dt=%10g dtm=%10g a=%10g e=%10g J=%10g omega=%10g%s\n", \
        (COLOUR),                                                       \
        (HEADER),                                                       \
        (STARDATA)->model.time,                                         \
        (STARDATA)->model.dt,                                           \
        (STARDATA)->model.dtm,                                          \
        (STARDATA)->common.orbit.separation,                            \
        (STARDATA)->common.orbit.eccentricity,                          \
        (STARDATA)->common.orbit.angular_momentum,                      \
        (STARDATA)->common.orbit.angular_frequency,                     \
        COLOUR_RESET                                                    \
        )

    Printf("************************************************************\n");
    _show_system(stardata,"","Orbit and System Derivatives");
    if(prev != NULL)
    {
        _show_system(prev,YELLOW,"Previous ...                ");
    }
    
    for(d=0;d<NUMBER_OF_SYSTEM_DERIVATIVES;d++)
    {
        if(Is_really_not_zero(stardata->model.derivative[d]))
        {
            dolog = TRUE;
            Printf("DERIV % 3d %30s : % 20g",
                   d,
                   corb[d],
                   stardata->model.derivative[d]);
            if(prev != NULL)
            {
                Printf(" : % 20g %%",
                       Percent_diff(stardata->model.derivative[d],
                              prev->model.derivative[d]));
            }
            Printf("\n");
        }
    }
    if(dolog==FALSE)
    {
        Printf("All derivatives (stellar and system) are zero\n");
    }
    Printf("************************************************************\n");
    
}
