#include "../binary_c.h"
#include <stdarg.h>

void set_logstring(const unsigned int N,
                   struct stardata_t * const stardata,
                   ...)
{                      
    va_list args;
    va_start(args, stardata); 
    Boolean wasset = stardata->model.logflags[(N)];        
    stardata->model.logflags[(N)]=TRUE;                             
    char * format = va_arg(args,char *);

    if(format == NULL)
    {
        /*
         * unset logstring
         */
        stardata->model.logflagstrings[(N)][0] = '\0';
        stardata->model.logflagstrings[(N)][1] = '\0';
        stardata->model.logflags[(N)] = FALSE;
        int ilog = 0;                                               
        while(ilog<NLOGFLAGS)                                       
        {
            if(stardata->model.logstack[ilog] == (N))
            {
                stardata->model.logstack[ilog] = LOG_NONE;
            }
            ilog++;
        }        
    }
    else
    {
        /*
         * Set a string in the log
         */
        vsnprintf(stardata->model.logflagstrings[(N)],                   
                  (STRING_LENGTH-1),
                  format,
                  args);                        

        /* set next free stack item to N if necessary */                
        if(wasset == FALSE)                                             
        {                                                               
            int ilog = 0;                                               
            while(ilog<NLOGFLAGS)                                       
            {                                                           
                if(stardata->model.logstack[ilog]==LOG_NONE)            
                {
                    if((ilog>0 &&                                       
                        stardata->model.logstack[ilog-1]!=(N)) ||       
                       ilog==0)                                         
                    {
                        stardata->model.logstack[ilog] = (N);
                        break;
                    }
                }                                                       
                ilog++;
            }
        }
    }

    va_end(args);
}
