#include "../binary_c.h"

/*
 * Function to open binary_c's log files
 */
void open_log_files(FILE *(*log_fp),
                    struct stardata_t * RESTRICT const stardata)
{   
#ifdef FILE_LOG
  
#ifdef FILE_LOG_REWIND
    if(likely(*log_fp!=NULL && *log_fp!=stdout && *log_fp!=stderr))
    {
        /* log is already open, just rewind and truncate it */
        Dprint("rewind log_fp\n");
        rewind(*log_fp);
        int x=ftruncate(fileno(*log_fp),0);
        if(x!=0)
        {
            fprintf(stderr,"Warning: ftructate failed in open_log_files\n");
        }
    }
#else
    /* check for null log */
    if(*log_fp!=NULL)
    {
        fclose(*log_fp);
        fprintf(stderr,"CLOSE before OPEN\n");
        *log_fp=NULL;
    }
#endif

    if(unlikely(Strings_equal(stardata->preferences->log_filename,
                              "/dev/null")))
    {
        /* force a NULL pointer so we do nothing */
        *log_fp = NULL;
    }
    else if(unlikely(Strings_equal(stardata->preferences->log_filename,
                                   "/dev/stdout")))
    {
        /* redirect output to stdout */
        *log_fp=stdout;
        fprintf(*log_fp,"      TIME      M1       M2   K1 K2        SEP    ECC  R1/ROL1 R2/ROL2  TYPE");
#ifdef CIRCUMBINARY_DISK_DERMINE
        fprintf(*log_fp,"     MCBDISK");
#endif
        fprintf(*log_fp,"\n");
#ifdef FILE_LOG_FLUSH
        fflush(*log_fp);
#endif
    }
    else if(unlikely(Strings_equal(stardata->preferences->log_filename,
                                   "/dev/stderr")))
    {
        /* redirect output to stderr */
        *log_fp=stderr;
        fprintf(*log_fp,"      TIME      M1       M2   K1 K2        SEP    ECC  R1/ROL1 R2/ROL2  TYPE");
#ifdef CIRCUMBINARY_DISK_DERMINE
        fprintf(*log_fp,"     MCBDISK");
#endif // CIRCUMBINARY_DISK_DERMINE
        fprintf(*log_fp,"\n");
#ifdef FILE_LOG_FLUSH
        fflush(*log_fp);
#endif // FILE_LOG_FLUSH
    }
    else
    {
        /* open log and check for error */
        if(*log_fp==NULL &&
           unlikely((*log_fp=fopen(stardata->preferences->log_filename,"w"))==NULL) )
        {
            perror("open_log_files error on open log_fp");
            char errorstring[1024];
            if(strerror_r(errno,errorstring,1024)!=0)
            {
                fprintf(stderr,"%s\n",errorstring);
            }
            fflush(NULL);
            Exit_binary_c(BINARY_C_FILE_OPEN_ERROR,
                          "Warning: Can't open %s for FILE_LOG output, error number %d\n",stardata->preferences->log_filename,errno);
        }
        else
        {
            fprintf(*log_fp,
                    "      TIME      M1       M2   K1  K2           SEP   ECC  R1/ROL1 R2/ROL2  TYPE RANDOM_SEED=%ld RANDOM_COUNT=%ld",
                    (stardata->preferences->cmd_line_random_seed!=0 ? 
                     stardata->preferences->cmd_line_random_seed : 
                     (long int)stardata->common.random_seed),
                    stardata->common.random_buffer.count
                );
#ifdef CIRCUMBINARY_DISK_DERMINE
            fprintf(*log_fp,"     MCBDISK");
#endif // CIRCUMBINARY_DISK_DERMINE
#ifdef LOG_REPEAT_NUMBER
            if(stardata->preferences->repeat>1)
            {
                fprintf(*log_fp," %d/%d",
                        1+stardata->model.repeat_number,
                        stardata->preferences->repeat);
            }
#endif//LOG_REPEAT_NUMBER
            fprintf(*log_fp,"\n");
#ifdef FILE_LOG_FLUSH
            fflush(*log_fp);
#endif // FILE_LOG_FLUSH
        }
    }

#if defined RANDOM_SYSTEMS && defined RANDOM_SYSTEMS_SHOW_ARGS
    if(stardata->preferences->random_systems && *log_fp)
    {
        fprintf(*log_fp,
                "--M_1 %30.20e --M_2 %30.20e --orbital_period %30.20e --eccentricity %30.20e --metallicity %30.20e --random_seed %lld\n",
                stardata->star[0].mass,
                stardata->star[1].mass,
                stardata->common.zams_period,
                stardata->common.zams_eccentricity,
                stardata->common.metallicity,
                (long long int)stardata->common.random_seed
            );
    }
#endif
  
    /*
     * Flush stdout, or everything for debug versions
     */
#if (DEBUG==1)
    fflush(NULL);
#endif

#endif/*FILE_LOG*/

}
