#include "../binary_c.h"

void logwrap(struct stardata_t * RESTRICT const stardata,
             const char * RESTRICT const label)
{

#ifdef FILE_LOG
    /*
     * Wrapper for the most common logging cases
     */
    output_to_logfile(stardata->model.log_fp,
                      stardata->model.time,
                      stardata->star[0].mass,
                      stardata->star[1].mass,
                      stardata->star[0].stellar_type,
                      stardata->star[0].hybrid_HeCOWD,
                      stardata->star[1].stellar_type,
                      stardata->star[1].hybrid_HeCOWD,
                      stardata->common.orbit.separation,
                      stardata->common.orbit.eccentricity,
                      (Is_zero(stardata->star[0].roche_radius) ? 0.0 : 
                       Max(0.0,stardata->star[0].radius/stardata->star[0].roche_radius)),
                      (Is_zero(stardata->star[1].roche_radius) ? 0.0 : 
                       Max(0.0,stardata->star[1].radius/stardata->star[1].roche_radius)),
                      label,
                      stardata);
#endif
}
