#include "../binary_c.h"

void log_rotation_checks(struct star_t *star)
{
#ifdef ROTATION_CHECKS
    if (star->stellar_type==MASSLESS_REMNANT) return;
    double omega=star->angular_momentum/(star->k2*Pow2(star->radius)*(star->mass-star->core_mass)+
                              K3*star->mass*Pow2(star->radius)); // per year
    double vrot=star->radius*omega/OMEGA_FROM_VKM; // km/s
    double vcrit=1e-5*sqrt(GRAVITATIONAL_CONSTANT*(star->mass*M_SUN)/(star->radius*R_SUN)); // km/s      

    // for omega_core we have to calculate j_core, which is jstar - jenv
    //double omega_core=(star->angular_momentum- star->k2*(star->mass-star->core_mass)*Pow2(star->radius))
    ///(K3*star->core_mass*Pow2(star->core_radius)); // per year
    double omega_core=omega;
    double vrot_core=star->core_radius*omega_core/OMEGA_FROM_VKM; // km/s
    double vcrit_core=1e-5*sqrt(GRAVITATIONAL_CONSTANT*(star->core_mass*M_SUN)/(star->core_radius*R_SUN)); // km/s      

    printf("ROTCHECK star%d type=%d M=%g Mc=%g %d o=%g vrot=%g vcrit=%g f=%g ; ",
           star->starnum,
           star->stellar_type,
           star->mass,
           star->core_mass,
           star->core_mass>0,
           omega,vrot,vcrit,vrot/vcrit);

    if(star->core_mass>0)
    {
        printf("%g %g %g %g",omega_core,vrot_core,vcrit_core,vrot_core/vcrit_core);
    }
    printf("\n");
#endif
}
