/* 
 * Function to close binary_c's log file streams
 */
#include "../binary_c.h"

void close_log_files(FILE *(*log_fp),
                     struct stardata_t * RESTRICT const stardata)    
{ 

#ifdef DISCS
#ifdef DISC_LOG_2D
    if(unlikely(stardata->tmpstore->disc_logfile2d != NULL))
    {
        binary_c_fclose(&stardata->tmpstore->disc_logfile2d);
        stardata->tmpstore->disc_logfile2d=NULL;
    }
#endif //DISC_LOG_2D
#ifdef DISC_LOG
    if(unlikely(stardata->tmpstore->disc_logfile != NULL))
    {
        binary_c_fclose(&stardata->tmpstore->disc_logfile);
        stardata->tmpstore->disc_logfile=NULL;
    }
#endif //DISC_LOG
#endif//DISCS


    /* if log_fp is stdout then just leave it! */
    if((*log_fp == stdout)||(*log_fp==stderr)) return;
    

#ifdef FILE_LOG
    Dprint("FP trying to close files\n");
    if(*log_fp!=NULL && unlikely(fclose(*log_fp)!=0))
    {
        perror("open_log_files error on close log_fp");
        char errorstring[1024];
        if(strerror_r(errno,errorstring,1024)!=0)
        {
            fprintf(stderr,"%s\n",errorstring);
        }
        fflush(NULL);
        Exit_binary_c(BINARY_C_FILE_CLOSE_ERROR,
                      "Warning : Can't close log file, error number %d\n",
                      errno);
    }
    *log_fp=NULL;
    Dprint("FP closed, FP=%p=%p\n",log_fp,*log_fp);
#endif/* FILE_LOG */


}
