#include "../binary_c.h"
#include <stdarg.h>

void append_logstring(const unsigned int N,
                      struct stardata_t * const stardata,
                      ...)
{
    /*
     * Append a string to the log
     */
    va_list args;
    va_start(args, stardata);
    char * const s = stardata->model.logflagstrings[(N)];
    const Boolean wasset = stardata->model.logflags[(N)];
    
    if(s==NULL)
    {
        set_logstring((N),stardata,args);
    }
    else
    {
        char cstring[STRING_LENGTH];
        size_t istring = strnlen(s,
                                 STRING_LENGTH-1);
        istring = Max(0,istring);

        /* insert separator prior to append, if we should/can */
        if(
            istring > 0 && //should
            istring < STRING_LENGTH-4 //can
            )
        {
            if(s[istring-1] == ' ')
            {
                /*
                 * Last char is a space : overwrite this also
                 */
                istring--;
            }

            /*
             * Insert separator at position istring
             */
            s[istring++] = ' ';
            s[istring++] = '-';
            s[istring++] = ' ';

            /* new NULL char at the end */
            s[istring] = '\0';
        }
        
        /*Append_logstring_debug1;*/
        const char * format = va_arg(args,char *);
        if(vsnprintf(cstring,
                     Max(0,STRING_LENGTH-1-istring),
                     format,
                     args) > 0)
        {
            /*
            printf("append logstring N=%d stardata = %p : string = %p = \"%s\", cstring = %p = \"%s\"\n",
                   N,
                   stardata,
                   s,
                   s,
                   cstring,
                   cstring);
            */
            strlcat(s,
                    cstring,
                    STRING_LENGTH-1);

            /*
              istring = strnlen(s,
                                STRING_LENGTH-1);
            */        
            /*Append_logstring_debug2;*/
            stardata->model.logflags[(N)] = TRUE;
        }
    }

    /* set next free stack item to N */
    if(wasset == FALSE)
    {
        int ilog = 0;
        while(ilog<NLOGFLAGS)
        {
            if(stardata->model.logstack[ilog]==LOG_NONE)
            {
                if((ilog>0 &&
                    stardata->model.logstack[ilog-1]!=(N)) ||
                   ilog==0)
                {
                    stardata->model.logstack[ilog] = (N);
                    break;
                }
            }
            ilog++;
        }
    }

    va_end(args);
}
