#!/usr/bin/env perl
use rob_misc;

# script to sync the latest librinterpolate to binary_c

my $src = "$ENV{HOME}/git/librinterpolate/src/";
my $dest = '.';

`rsync -avP $src/*.c ./`;
`rsync -avP $src/*.h ./`;
`rsync -avP CHANGELOG LICENCE ./`;
unlink 'test_rinterpolate.c';

foreach my $cfile (`ls *.c`)
{
    chomp $cfile;
    my $code = slurp($cfile);

    $code = '
#include "../binary_c_error_codes.h"
#include "../binary_c_exit_macros.h"
#include "../breakpoints/breakpoints_prototypes.h"
#include "../binary_c_exit_prototypes.h"

#ifndef __HAVE_LIBRINTERPOLATE__

' . $code . '
#endif // __HAVE_LIBRINTERPOLATE__
        ';

    $code =~s/exit\(errnum\)/Exit_binary_c_no_stardata(BINARY_C_IMPORTED_CODE_ERROR,\"Error in librinterpolate in binary_c\")/;

    dumpfile($cfile,$code);

}

