
#include "../binary_c_error_codes.h"
#include "../binary_c_exit_macros.h"
#include "../breakpoints/breakpoints_prototypes.h"
#include "../binary_c_exit_prototypes.h"

#ifndef __HAVE_LIBRINTERPOLATE__

#include "rinterpolate.h"
#include "rinterpolate_internal.h"
/*
 * Allocate memory for rinterpolate: to be called ONCE per process only.
 */

#ifdef RINTERPOLATE_DEBUG
int rinterpolate_debug;
#endif

rinterpolate_counter_t rinterpolate_alloc_dataspace(struct rinterpolate_data_t ** RESTRICT const r)
{
    if(*r != NULL)
    {
        rinterpolate_error(RINTERPOLATE_ALLOCATE_OVER,
                           "Attempted to allocate rinterpolate a non-NULL pointer\n",
                           *r);
        return RINTERPOLATE_ALLOCATE_OVER;
    }
    else
    {
        /*
         * Allocate space
         */
        *r = Rinterpolate_calloc(1,sizeof(struct rinterpolate_data_t));
        return 0;
    }
}


#endif // __HAVE_LIBRINTERPOLATE__
        