#include "../binary_c.h"

void file_splitline(FILE * const fp,
                    const char comment_char,
                    const char * const delimiter,
                    char *** array,
                    size_t * narray)
{
    /*
     * Read the first line of fp, ignoring any leading comment_char 
     * if it is non-zero, and return an array of character strings
     * split on deliiter. 
     *
     * array contains pointers to new character substrings, with narray elements,
     * and these will need freeing once you are finished with them.
     *
     * On error, *narray is set to -1 and **array is undefined.  
     */
    
    /*
     * get data line
     */
    size_t n = 0;
    char * line = NULL;
    *array = NULL;
    
    if(getline(&line,&n,fp)>0)
    {
        /*
         * Remove trailing newline
         */
        chomp(line);
        
        /*
         * Check for comment character
         */
        Boolean found_comment;
        if(comment_char != 0 &&
           line[0] == comment_char)
        {
            found_comment = TRUE;
            line++;
        }
        else
        {
            found_comment = FALSE;
        }

        /*
         * Split as required
         */
        char * saveptr = NULL;
        char * c;
        n = 0; /* reuse n */
        c = strtok_r(line,
                     delimiter,
                     &saveptr);
        while(c != NULL)
        {
            size_t len = strlen(c) + 1; /* +1 to include trailing NULL */
            *array = Realloc(*array,
                             sizeof(char**)*(n+1));
            char * dest = (*array)[n] = Malloc(sizeof(char) * len);
            strlcpy(dest,c,len);
            n++;
            c = strtok_r(NULL,
                         delimiter,
                         &saveptr);
        }

        if(line != NULL)
        {
            /* 
             * Free line and make sure it is NULL
             */
            if(found_comment)
            {
                line--;
            }
            Safe_free(line);
            line = NULL;            
        }
        
        *narray = n;
    }
    else
    {
        *narray = -1;
    }
}
