
#ifndef FILE_H
#define FILE_H

struct binary_c_file_t * binary_c_fopen(const char * RESTRICT const path,
                                      const char * RESTRICT const mode,
                                      const size_t maxsize);
int binary_c_fprintf(struct binary_c_file_t * const file,
                     const char * const format,
                     ...) Gnu_format_args(2,3);
int binary_c_fclose(struct binary_c_file_t ** file);
int binary_c_fflush(const struct binary_c_file_t * const file);
int binary_c_filter_fprintf(struct binary_c_file_t * const file,
                            const int filter_algorithm,
                            const char * const format,
                            ...) Gnu_format_args(3,4);
int binary_c_vprintf(struct binary_c_file_t * file,
                     const char * const format,
                     va_list args) Gnu_format_args(2,0);
int binary_c_filter_vprintf(struct binary_c_file_t * const file,
                            const int algorithm,
                            const char * const format,
                            va_list args) Gnu_format_args(3,0);
char * binary_c_filter_format(const int algorithm,
                              const char * format);
long int file_linecount (const char * const filename,
                         const char comment_char);                              
void file_splitline(FILE * const fp,
                    const char comment_char,
                    const char * const delimiter,
                    char *** array,
                    size_t * narray);
#endif// FILE_H
