#include "../binary_c.h"

long int file_linecount (const char * const filename,
                         const char comment_char)
{
    /*
     * Count lines in a file, ignoring those
     * that start with comment_char, if given.
     * 
     * If comment_char is 0 it is ignored.
     *
     * Returns the number of lines, or -1 on error. 
     */
    long int nlines;
    FILE * fp = fopen(filename,"r");
    if(fp != NULL)
    {
        Boolean start = TRUE;
        nlines = 0;
        while(fp != NULL)
        {
            int c = getc(fp);
            if(comment_char != 0 &&
               start == TRUE &&
               c == comment_char)
            {
                /*
                 * Found comment character : skip everything until the end of the line
                 */
                Boolean x = TRUE;
                start = FALSE;
                while(x == TRUE)
                {
                    c = getc(fp);
                    if(c == '\n') 
                    {
                        /*
                         * End of line: exit loop
                         */
                        x = FALSE;
                    }
                    else if(c == EOF)
                    {
                        /*
                         * End of file
                         */
                        x = FALSE;
                        fclose(fp);
                        fp = NULL;
                    }
                }
            }
            else if(c == '\n')
            {
                /*
                 * Found end of line : increment counter
                 */
                nlines++;
            }
            else if(c == EOF)
            {
                /*
                 * End of file 
                 */
                fclose(fp);
                fp = NULL;
            }
        }
    }
    else
    {
        /*
         * Error: return -1
         */
        nlines = -1;
    }
    return nlines;
}
