
#include "../binary_c.h"

struct binary_c_file_t * binary_c_fopen(const char * RESTRICT const path,
                                      const char * RESTRICT const mode,
                                      const size_t maxsize)
{
    /*
     * open the file at "path" with mode "mode",
     *
     * Set its maxsize, which is ignored if zero,
     * and current size (zero).
     *
     * Returns a pointer to the newly allocated file struct.
     *
     * The return value from fopen is set as file->fp
     *
     * On failure, returns NULL and frees all 
     * associated memory.
     */
    struct binary_c_file_t * file = Malloc(sizeof(struct binary_c_file_t));
    if(file != NULL)
    {
        file->fp = fopen(path,mode);        
#ifdef MEMOIZE
        file->memo = NULL;
#endif // MEMOIZE
        if(file->fp)
        {
            /* 
             * Opened ok, set values.
             */
            file->size = 0;
            file->maxsize = maxsize;
            strlcpy(file->path,
                    path,
                    sizeof(char)*(STRING_LENGTH-1));
        }
        else
        {
            /*
             * Failure: free to NULL
             */
            Safe_free(file);
        }
    }
    return file;
}
