
#include "../binary_c.h"

int binary_c_fflush(const struct binary_c_file_t * const file)
{
    /*
     * Flush a binary_c_file_t pointer.
     *
     * Return what is returned from fflush,
     * or -1 if file or file->fp is NULL
     */
    int ret;
    if(likely(file != NULL) &&
       likely(file->fp != NULL))
    {
        ret = fflush(file->fp);
    }
    else
    {
        ret = -1;
    }
    return ret;
}
