/*
 * Generic code exit function which attempts some clean up of memory.
 *
 * Note the unusual header file list: please do not change it! :)
 */

#include <stdlib.h>
#include <stdarg.h>

#ifdef _GNU_SOURCE
#define GNU_SOURCE_WAS _GNU_SOURCE
#endif

#define _GNU_SOURCE
#include <stdio.h>
#undef __USE_GNU
#undef _GNU_SOURCE
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "binary_c.h"

#undef Dprint
#if defined DEBUG && DEBUG!=0
#define Dprint(...) fprintf(stderr,__VA_ARGS__);
#else
#define Dprint(...) /* do nothing */
//#define Dprint(...) fprintf(stdout,__VA_ARGS__);
#endif

static void exit_binary_c_handler(struct stardata_t * stardata,
                                  char * filename,
                                  const int fileline,
                                  const int errsv,
                                  const int binary_c_error_code,
                                  char * format,
                                  va_list args) No_return Gnu_format_args(6,0);

void Gnu_format_args(6,7) No_return exit_binary_c_with_stardata(struct stardata_t * stardata,
                                                                char * filename,
                                                                const int fileline,
                                                                const int errsv,
                                                                const int binary_c_error_code,
                                                                char * format,
                                                                ...)
{
    /*
     * Function to handle the shutdown of BINARY_C in a clean manner:
     * You should never call this function directly, instead use the 
     * Exit_binary_c macro.
     *
     * You must always call Exit_binary_c as:
     *
     * Exit_binary_c(binary_c_error_code, format-string, <arguments>)
     *
     * where 
     * + the binary_c_error_code is defined in binary_c_macros.h
     * + the format string is appropriate for passing to printf
     * + the (optional) arguments requried for the format are also given.
     * 
     * e.g.
     *
     * Exit_binary_c(10,"Code exited because mass = %g\n",mass);
     *
     * The error message is shown if binary_c_error_code is non-zero, or if
     * debugging is switched on (DEBUG=1)
     *
     * Note that errsv is a saved version of the C library's "errno"
     * variable. It is NOT the same as binary_c_error_code which is
     * a number defined by binary_c_error_codes.h
     */
    Dprint("In Exit_binary_c : setting up varargs, stardata=%p\n", 
	   stardata);
    if(stardata!=NULL)
    {
        Dprint("preferences = %p\n",stardata->preferences);
#ifdef BATCHMODE
        Dprint("batchmode = %d\n",stardata->preferences != NULL ? stardata->preferences->batchmode : BATCHMODE_ERROR);
#endif //BATCHMODE
    }

    va_list args;
    va_start(args,format);
    exit_binary_c_handler(stardata,
                          filename,
                          fileline,
                          errsv,
                          binary_c_error_code,
                          format,
                          args);
    va_end(args);

}

void Gnu_format_args(5,6) No_return exit_binary_c_no_stardata(char * filename,
                                                              const int fileline,
                                                              const int errsv,
                                                              const int binary_c_error_code,
                                                              char * format,
                                                              ...)
{
    va_list args;
    va_start(args,format);
    exit_binary_c_handler(NULL,
                          filename,
                          fileline,
                          errsv,
                          binary_c_error_code,
                          format,
                          args);
    va_end(args);
}


static void No_return Gnu_format_args(6,0) exit_binary_c_handler(struct stardata_t * stardata,
                                                                 char * filename,
                                                                 const int fileline,
                                                                 const int errsv,
                                                                 const int binary_c_error_code,
                                                                 char * format,
                                                                 va_list args)
{
    char s[MAX_EXIT_STATEMENT_PRINT_SIZE];
    vsnprintf(s,MAX_EXIT_STATEMENT_PRINT_SIZE,format,args);
    chomp(s);
    

    Boolean longjump = (binary_c_error_code != BINARY_C_NORMAL_BATCHMODE_EXIT &&
                        binary_c_error_code != BINARY_C_SPECIAL_EXIT)
#ifdef BATCHMODE
        && (stardata!=NULL)
        && (stardata->preferences != NULL)  
        && (Batchmode_is_on(stardata->preferences->batchmode))
#else
        && 0
#endif // BATCHMODE
	;
    
    
    Dprint("Check batchmode : longjump = %d from %p %p %d %d\n",longjump,
           stardata,
           stardata!=NULL ? stardata->preferences : NULL,
           (stardata!=NULL && stardata->preferences!=NULL) ? stardata->preferences->batchmode : -1,
           (stardata!=NULL && stardata->preferences!=NULL) ? Batchmode_is_on(stardata->preferences->batchmode) : -1
        );
    if(longjump)
    {
        /* in batchmode, we don't want to exit, just print a message */
	Dprint("batchmode : but we don't want to quit");
        if(binary_c_error_code!=BINARY_C_SPECIAL_EXIT)
        {
            _printf("SYSTEM_ERROR file %s, line %d, with error code %d: %s (errno=%d)\n",
                    filename,fileline,binary_c_error_code,s,errno);
            Printf("SYSTEM_ERROR file %s, line %d, with error code %d: %s (errno=%d)\n",
                   filename,fileline,binary_c_error_code,s,errno);
        }

        /* flush all files, close logs, longjmp back to batchmode function */
        Dprint("batchmode : long jump to %p\n",
               stardata->batchmode_setjmp_buf);
        fflush(NULL);
        stardata->store->debug_stopping = 0;
 	longjmp(stardata->batchmode_setjmp_buf,1);
    }
    else
    {
        /*
         * Non-batchmode or batchmode is off : actually exit
         */
        Dprint("binary_c : we really want to exit (not a batchmode long jump)\n");
        if((binary_c_error_code!=BINARY_C_NORMAL_EXIT && 
            binary_c_error_code!=BINARY_C_QUIET_EXIT &&
            binary_c_error_code!=BINARY_C_SPECIAL_EXIT &&
            binary_c_error_code!=BINARY_C_NORMAL_BATCHMODE_EXIT) || (DEBUG))
        {
            if(!isatty(fileno(stdout)))
            {
                /* stdout is not a terminal, so output to it */
                _printf("Exit binary_c from file %s, line %d, with error code %d: %s (errno=%d)\n",
                        filename,fileline,binary_c_error_code,s,errno);
            }
            
            /* ... and always output to stderr */
            fprintf(stderr,
                    "Exit binary_c from file %s, line %d, with error code %d: %s (errno=%d)\n",
                    filename,fileline,binary_c_error_code,s,errno);
        }

        /*
          fprintf(stderr,"Attempting backtrace from exit_binaryc\n");
          Backtrace;
        */
        
        /*
         * Free all allocated memory, including the preferences, store and tmpstore
         */
        if(stardata!=NULL) free_memory(&stardata,TRUE,TRUE,TRUE,TRUE); 
        
#undef exit
        
        if(binary_c_error_code == BINARY_C_NORMAL_EXIT || 
           binary_c_error_code == BINARY_C_SPECIAL_EXIT || 
	   binary_c_error_code == BINARY_C_NORMAL_BATCHMODE_EXIT)
	{
	    if(binary_c_error_code == BINARY_C_NORMAL_BATCHMODE_EXIT)
	    {
		_printf("Normal exit from binary_c (batchmode)\n");
	    }
	    else
	    {
		_printf("Normal exit from binary_c\n");
	    }
	}

        exit(binary_c_error_code);
    }
}


#ifdef GNU_SOURCE_WAS
#undef _GNU_SOURCE
#define _GNU_SOURCE GNU_SOURCE_WAS
#endif

