#include "../binary_c.h"

/*
 * Update the time by adding the timestep
 * (NB use dtm because time is in megayears)
 */
void update_the_time(struct stardata_t * RESTRICT const stardata)
{
    stardata->model.time   +=
#ifdef REVERSE_TIME
        (stardata->preferences->reverse_time == FALSE ? +1.0 : -1.0) *
#endif // REVERSE_TIME
        stardata->model.dtm;

    Dprint("%sincrease time by dtm=%30.12e to %30.12e (log=%30.20g)%s\n",
           GREEN,
           stardata->model.dtm,
           stardata->model.time,
           log10(stardata->model.time),
           COLOUR_RESET);

}
