#include "../binary_c.h"

/*
 * A function to collect together all the stuff that should happen
 * when we start evolving a system.
 *
 * Note that the system does not have to have time == zero, 
 * it could start evolving half way through its lifetime.
 *
 * We only call initialize_parameters if model_number == 0
 * (i.e. on the first timestep).
 */

void start_of_evolution(struct stardata_t *stardata)
{

    Dprint("First run\n");

    /*************************************/
    /** set up variables and parameters **/
    /*************************************/
    set_metallicities(stardata);
    
    
#ifdef BSE
    /* set metallicity parameters */
    Dprint("Setting up local variables, calling set_metallicity_parameters\n");
    set_metallicity_parameters(stardata);
#endif //BSE
    
    /* 
     * Initialize stardata parameters
     * for first model.
     */
    if(stardata->model.model_number == 0)
    {
        Dprint("calling initialize_parameters\n");
        initialize_parameters(stardata);
    }
    
   
#ifdef NO_IMMEDIATE_MERGERS
    stardata->model.evolution_number = 0;
#endif

    setup_fixed_timesteps(stardata);
    
    /* maybe require thermal timescales before RLOF */
    set_kelvin_helmholtz_times(stardata);

    /* check if we want to show the period/separation at which RLOF begins */
    show_instant_RLOF_period_or_separation(stardata);    
    Evolution_logging;
    Dprint("done\n");
}
