#include "../binary_c.h"

void start_RLOF(struct stardata_t * RESTRICT const stardata)
{
    /* Beginning of Roche Lobe Overflow */
    Dprint("Roche Lobe Overflow! Setting nuclear_timescale etc.\n");
          
    stardata->model.in_RLOF = TRUE;

    Dprint("RLOF off -> on (0 : r=%g roche_radius=%g, 1: r=%g roche_radius=%g)\n",
           stardata->star[0].radius,stardata->star[0].roche_radius,
           stardata->star[1].radius,stardata->star[1].roche_radius);

    /* Set the nuclear timescale in years and slow-down factor.*/     
    set_nuclear_timescale_and_slowdown_factor(stardata);
          
    Dprint("Set nuclear timescale etc.\n");
      
    /* 
     * Force co-rotation of primary and orbit
     * to ensure that the tides do not
     * lead to unstable Roche. 
     */
    if(stardata->preferences->force_corotation_on_RLOF)
    {
        force_corotation_of_primary_and_orbit(stardata);
    }
}
