#include "../binary_c.h"

void set_next_timestep(struct stardata_t * RESTRICT const stardata)
{
 
    /*
     * Set the timestep to be the minimum of the stellar 
     * timesteps and the time remaining
     */
    double dtmwas MAYBE_UNUSED = stardata->model.dtm;
    double time_remaining = stardata->model.max_evolution_time - stardata->model.time;
    Dprint("Set dtm = Min3(star0 = %g, star1 = %g, remaining = %g, zoomfac = %g)\n",
           stardata->star[0].stellar_timestep,
           stardata->star[1].stellar_timestep,
           stardata->model.max_evolution_time-stardata->model.time,
           stardata->model.dt_zoomfac
        );
        

    /*
     * Choose the minimum of all the stars and the 
     * time remaining.
     */
    stardata->model.dtm = time_remaining;
    Star_number k;
    Starloop(k)
    {
        stardata->model.dtm = Min(stardata->model.dtm,
                                  stardata->star[k].stellar_timestep);
    }

    /*
     * Do not let the timestep be > maximum_timestep_factor * previous timestep
     */
    if(Is_not_zero(dtmwas) &&
       Is_not_zero(stardata->preferences->maximum_timestep_factor))
    {
        stardata->model.dtm = Min(stardata->preferences->maximum_timestep_factor * dtmwas,
                                  stardata->model.dtm);
    }
    
    
    /*
     * Save the timestep on the first
     * RLOF iteration
     */
    if(stardata->model.iter==0) stardata->model.dtm0 = stardata->model.dtm;    

    /*
     * Apply zoom factor 
     */
    stardata->model.dtm *= stardata->model.dt_zoomfac;

    /*
     * Calculate timestep in years
     */
    stardata->model.dt = 1e6 * stardata->model.dtm;
    
    Dprint("at t=%20.12g next timestep is dtm=%g Myr (stellar_timestep %g,%g, dtr=%g) dt=%g (dt_zoomfac=%g)\n",
           stardata->model.time,
           stardata->model.dtm,
           stardata->star[0].stellar_timestep,
           stardata->star[1].stellar_timestep,
           stardata->model.max_evolution_time-stardata->model.time,
           stardata->model.dt,
           stardata->model.dt_zoomfac);
}
