#pragma once
#ifndef REJECTION_MACROS_H
#define REJECTION_MACROS_H


/*
 * Macros specific to binary_c's timestep rejection algorithm.
 *
 * Note that REJECT_NONE must be zero (i.e. FALSE).
 */

#define REJECT_NONE 0
#define REJECT_RLOF 1
#define REJECT_ANGMOM 2
#define REJECT_TEFF 3
#define REJECT_LUMINOSITY 4

#define Reject_string(N)                                \
    (                                                   \
        (N) == REJECT_NONE ? "none" :                   \
        (N) == REJECT_RLOF ? "RLOF" :                   \
        (N) == REJECT_ANGMOM ? "angular momentum" :     \
        (N) == REJECT_TEFF ? "Teff" :                   \
        (N) == REJECT_LUMINOSITY ? "luminosity" :                \
        "unknown"                                       \
        )

#endif // REJECTION_MACROS_H
