#include "../binary_c.h"

int loop_check(struct stardata_t * RESTRICT const stardata,
               const int evstatus)
{
    /*
     * Evolution loop control based on the 'evstatus' value, 
     * as returned by an evolve_* function (* = RLOF or detached)
     * 
     * LOOP_NOW    : return EVOLUTION_CONTINUE 
     * 
     * LOOP        : return EVOLUTION_CONTINUE if loop_iteration is TRUE,
     *               otherwise EVOLUTION_BREAK
     * 
     * LOOP_RLOF   : return EVOLUTION_CONTINUE_RLOF
     *
     * LOOP_REJECT : call evolution_rejected(), usually returns 
     *               EVOLUTION_REJECT, but maybe EVOLUTION_CONTINUE_RLOF
     * 
     * STOP        : return EVOLUTION_BREAK
     * 
     * FALSE       : return EVOLUTION_NO_ACTION_REQUIRED 
     *               (should not happen)
     */
    int ret = EVOLUTION_NO_ACTION_REQUIRED;
    Dprint("evstatus = %d\n",evstatus);
    if(evstatus)
    {
        if(evstatus == LOOP_REJECT)
        {
            Dprint("REJECT at t=%g dt=%g dtm=%g\n",
                   stardata->model.time,
                   stardata->model.dt,
                   stardata->model.dtm);
            ret = evolution_rejected(stardata);
        }
        else
        {
            evolution_success(stardata);

            if(evstatus == LOOP)
            {
                ret = EVOLUTION_CONTINUE;
            }
            /*else if(evstatus == LOOP)
            {
                ret = (loop_evolution(stardata)==TRUE) ?
                    EVOLUTION_CONTINUE : EVOLUTION_BREAK; 
                    }
            */
            else if(evstatus == LOOP_NOW)
            {
                ret = EVOLUTION_CONTINUE;
            }
            else if(evstatus == LOOP_RLOF)
            {
                ret = EVOLUTION_CONTINUE_RLOF;
            }
            else if(evstatus == STOP)
            {
                ret = EVOLUTION_BREAK;
            }
        }
    }
    else
    {
        ret = EVOLUTION_NO_ACTION_REQUIRED;
    }

    return ret;
}
