#include "../binary_c.h"


/* 
 * This function contains stuff we need to initialize every timestep
 * for a generic system.
 */

static void initialize_generic_system_every_timestep_star(struct star_t * RESTRICT star);
static void initialize_generic_system_every_timestep2(struct stardata_t * RESTRICT const stardata);

void initialize_generic_system_every_timestep(struct stardata_t * RESTRICT const stardata)

{
    Dprint("Initialize detached system every timestep : masses %g %g\n",
           stardata->star[0].mass,
           stardata->star[1].mass
        );
    initialize_generic_system_every_timestep2(stardata);
    {
        Star_number k;
        Starloop(k)
        {
            SETstar(k);
            initialize_generic_system_every_timestep_star(star);
        }
    }
}

void initialize_generic_system_every_timestep2(struct stardata_t * RESTRICT const stardata)
{
    struct model_t * model=&(stardata->model);
    model->prec = FALSE;
    model->supernova = FALSE;
    model->com = FALSE;
    model->coalesce = FALSE;
    model->tphys0 = model->time;
#if defined NUCSYN && defined NUCSYN_GCE
    /* force evolution to resolve at least one yields_dt time */
    stardata->preferences->yields_dt = Min(stardata->preferences->yields_dt,
                                           stardata->model.max_evolution_time);
#endif//NUCSYN
    model->ndonor = 0;
    model->naccretor = 1;
    zero_stellar_mass_and_angmom_derivatives(stardata);
#ifdef DISCS
    disc_initialize_every_timestep(stardata);
#endif
    Star_number k;
    Starloop(k)
    {
        SETstar(k);
        star->reject = REJECT_NONE;
#if defined NUCSYN && defined NUCSYN_ANGELOU_LITHIUM
        star->angelou_lithium_boost_this_timestep = FALSE;
#endif // NUCSYN && NUCSYN_LITHIUM_ANGELOU
    }
}


static void initialize_generic_system_every_timestep_star(struct star_t * RESTRICT star)
{
#ifdef ADAPTIVE_RLOF
    star->prev_dm=0.0;
#endif
    if(COMPACT_OBJECT(star->stellar_type))
    {
        star->stellar_timestep=0.01;
    }
#if (defined(SELMA_FIX_ACCRETED_MASS_IN_REJUVENATION)||defined(SELMA_BETTER_TREATMENT_OF_MS_ACCRETORS))
    star->last_mass=star->mass;
#endif
}
