#include "../binary_c.h"

/*
 * On an RLOFing timestep, initialize parameters
 */

static void initialize_RLOFing_system_every_timestep_star(struct star_t * RESTRICT star);


void initialize_RLOFing_system_every_timestep(struct stardata_t * RESTRICT const stardata)
{
    struct model_t * model=&(stardata->model);
    model->coalesce = FALSE;
    model->supernova = FALSE;
    {
        Star_number k;
        Starloop(k)
        {
            SETstar(k);
            initialize_RLOFing_system_every_timestep_star(star);
        }
    }
#ifdef DISCS
    disc_initialize_every_timestep(stardata);
#endif
    Star_number k;
    Starloop(k)
    {
        SETstar(k);
        star->reject = REJECT_NONE;
#if defined NUCSYN && defined NUCSYN_ANGELOU_LITHIUM
        star->angelou_lithium_boost_this_timestep = FALSE;
#endif // NUCSYN && NUCSYN_LITHIUM_ANGELOU
    }
}



static void initialize_RLOFing_system_every_timestep_star(struct star_t * RESTRICT star)
{
#ifdef ADAPTIVE_RLOF
    star->prev_dm=0.0;
#endif
#if (defined(SELMA_FIX_ACCRETED_MASS_IN_REJUVENATION)||defined(SELMA_BETTER_TREATMENT_OF_MS_ACCRETORS))
    star->last_mass=star->mass;
#endif
}
